import logging
import yaml
import sys
import os


class Config(object):

    def __init__(self, args=None):
        config_file = args.config
        self.debug_mode = args.debug

        config_data = dict()
        if config_file is not None and os.path.isfile(config_file):
            with open(config_file) as cfg:
                config_data = yaml.safe_load(cfg)

        self.db = config_data.get('db', None)
        self.app = config_data.get('app', None)

