import argparse
import copy
import datetime
import logging
import math
import os
import socket
import sys
import threading
import time
from collections import defaultdict, namedtuple


QloudClient = namedtuple('QloudClient', ['installation', 'client'])


class MongoClient(object):
    def __init__(self, connector, reconnect_time):
        self.connector = connector
        self.reconnect_time = reconnect_time
        self.client = None
        self.last_connection_time = 0

    @property
    def db(self):
        if self._now - self.last_connection_time > self.reconnect_time:
            self.last_connection_time = self._now
            self.client = self._recreate_client()

        return self.client.qloud3

    def _recreate_client(self):
        if self.client:
            try:
                logging.info('closing old mongodb connection')
                self.client.close()
            except Exception as e:
                logging.error('unable to close database connection: ' + e.message, exc_info=True)
        logging.info('opening connection')
        self.client = self.connector()
        return self.client

    @property
    def _now(self):
        return int(1000 * time.time())
