#!/usr/bin/env python

# Provides: qloud_balancer_upstream_statuses

import json
import os
import urllib2

URL = "http://localhost:81/check-status"


def check_resp(r):
    if r.getcode() != 200:
        raise urllib2.URLError("%s raise %d" % (r.geturl(), r.getcode()))
    return r

def check_status():
    resp = check_resp(urllib2.urlopen(URL, timeout=10))
    upstreams = json.loads(resp.read()).get("servers", {}).get("server", [])
    import pprint
    failed = 0
    unknown = 0
    pprint.pprint(upstreams)
    for upstream in upstreams:
        if upstream.get("status") is not None:
            if upstream["status"] == "down":
                failed += 1
        else:
            unknown += 1
    if (float(failed + unknown) / float(len(upstreams))) > 50:
        return 2, "Failed: {}, Unknown: {}".format(failed, unknown)
    else:
        return 0, "OK"

def message(code, m):
    name = os.path.basename(__file__).split('.')[0]
    msg = "PASSIVE-CHECK:" + name + ";" + str(code) + ";" + m
    print msg


if __name__ == '__main__':
    res = 1
    msg = "Default"
    try:
        (res, msg) = check_status()
    except Exception as e:
        res = 2
        msg = e.__repr__()
    finally:
        message(res, msg)
