#!/usr/bin/env python

# Provides: qloud_balancer_workers

import psutil
import os




def check_nginx_workers():
    count = 0
    for p in psutil.process_iter():
        try:
            cmdline = p.as_dict(attrs=['cmdline'])['cmdline']
        except psutil.NoSuchProcess:
            pass
        else:
            if 'nginx: worker process' in cmdline:
                count += 1

    if count == 0:
        res = 2
        message = 'No workers found {}'.format(count)
    elif count == 1:
        res = 0
        message = 'Workers {}'.format(count)
    elif count == 2:
        res = 1
        message = 'Workers {}'.format(count)
    else:
        res = 2
        message = 'Too many workers {}'.format(count)

    return res, message


def message(code, m):
    name = os.path.basename(__file__).split('.')[0]
    msg = "PASSIVE-CHECK:" + name + ";" + str(code) + ";" + m
    print msg


if __name__ == '__main__':
    try:
        (res, msg) = check_nginx_workers()
    except Exception as e:
        res = 2
        msg = str(e)
    finally:
        message(res, msg)
