#!/usr/bin/python
# Provides: qloud_nginx_upstream_check
import json
import urllib2
import os

URL = "http://localhost:81/check-status"

def message(code, m):
    name = os.path.basename(__file__).split('.')[0]
    msg = "PASSIVE-CHECK:" + name + ";" + str(code) + ";" + m
    print msg


def check_resp(r):
    if r.getcode() != 200:
        raise urllib2.URLError("%s raise %d" % (r.geturl(), r.getcode()))
    return r


def check_upstream_status(warn, crit):
    servers = json.loads(check_resp(urllib2.urlopen(URL, timeout=3)).read()).get("servers", {}).get("server", [])

    failed = 0
    for server in servers:
        status = server.get("status", "down")
        if status == "down":
            failed += 1

    bad = failed
    total = len(servers)
    count = float(bad)*100.0/float(total)

    if count >= crit:
        return 2, "{} of {} upstreams down".format(bad, total)
    elif count >= warn:
        return 1, "{} of {} upstreams down".format(bad, total)
    else:
        return 0, "OK"

if __name__ == "__main__":
    try:
        with open("/etc/qloud/meta.json") as f:
            data = json.load(f)
            warn = data.get("user_environment", {}).get("QLOUD_UPSTREAMS_WARN", 20)
            crit = data.get("user_environment", {}).get("QLOUD_UPSTREAMS_CRIT", 50)
            (res, msg) = check_upstream_status(warn, crit)
    except Exception as e:
        res = 2
        msg = str(e)

    message(res, msg)
