#!/usr/bin/env bash
#
# Provides: qloud_router_config

me=qloud_router_config


send () {
    echo "PASSIVE-CHECK:$me;$1;$2"
    exit 0
}

get_running_hash () {
    NGINX_RUN_HASH=$(curl -s http://localhost/)
}

get_conf_hash () {
    NGINX_CONF_HASH=$(awk '/set \$qloud_configuration_hash/ {print $3}' $1  | tr -d "\';" | tail -1)
}

get_qloud_hash() {
    if [ -f /etc/qloud/meta.json ] && [ $(grep -c QLOUD_ROUTER_CONFIG_URL /etc/qloud/meta.json) -eq 1 ];
    then
        DC=$(grep datacenter /etc/qloud/meta.json  | awk '{print $2}' | sed 's/"//g;s/,//g')
        QLOUD_ROUTER_CONFIG_URL=$(grep QLOUD_ROUTER_CONFIG_URL /etc/qloud/meta.json  | awk '{print $2}' | sed 's/"//g;s/,//g')
        NGINX_QLOUD_HASH=$(curl -is "$QLOUD_ROUTER_CONFIG_URL/$DC" | awk  '/set \$qloud_configuration_hash/ {print substr($3,2,32)}' | tail -1)
    else
        if [ -f /etc/default/qloud-nginx-router-config ]
        then
            QLOUD_URL=$(grep QLOUD_MANAGEMENT_URL /etc/default/qloud-nginx-router-config | cut -d\" -f4)
            QLOUD_PATH=$(grep QLOUD_MANAGEMENT_PATH /etc/default/qloud-nginx-router-config | cut -d\" -f4)
            NGINX_QLOUD_HASH=$(curl -i "$QLOUD_URL/$QLOUD_PATH/config/$(hostname -f)" -s | awk  '/set \$qloud_configuration_hash/ {print substr($3,2,32)}')
        fi
    fi
}

CONF_FILE="/etc/nginx/sites-enabled/qloud-router"
if ! [ -s $CONF_FILE ]
then
    CONF_FILE="/etc/nginx/nginx.conf"
fi

if ! [ -s $CONF_FILE ]
then
    send 2 "Main config file not found - $CONF_FILE"
fi

get_running_hash
get_qloud_hash
get_conf_hash $CONF_FILE

i="0"
while [ -z "${NGINX_CONF_HASH}" ] ; do
    if [[ $i -gt 9 ]] ; then send 2 "Do not get hash after 10 times with 3 sec sleep" ; fi
    sleep 3
    get_conf_hash
    i=$((i+1))
done

if [ -z "${NGINX_QLOUD_HASH}" ] ; then
    send 2 "Cannot get router config from qloud-manager"
fi

if [ "${NGINX_QLOUD_HASH}" != "${NGINX_CONF_HASH}" ] ; then
    send 2 "Conf file hash does not match with qloud-manager hash; qloud_hash ${NGINX_QLOUD_HASH:0:6}, file_hash ${NGINX_CONF_HASH:0:6} (also running_hash ${NGINX_RUN_HASH:0:6}"
fi

if [ "${NGINX_CONF_HASH}" != "${NGINX_RUN_HASH}" ]
then
    send 2 "Inconsist qloud-nginx running config; (also qloud_hash ${NGINX_QLOUD_HASH:0:6}) file_hash ${NGINX_CONF_HASH:0:6}, runnning_hash ${NGINX_RUN_HASH:0:6}"
else
    send 0 "Actual config of qloud-nginx is running"
fi

exit 0
