import json
import os
import subprocess
import tempfile

from commands.upload import do_upload


def edit(qloud, args):
    env_id = args['ENVIRONMENT_ID']
    editor = os.getenv('EDITOR', 'vim')

    json_file = tempfile.mktemp(suffix=".json")

    with open(json_file, 'w') as f:
        json.dump(qloud.dump_environment(env_id), f, indent=4, separators=(',', ': '))
    subprocess.call([editor, json_file])
    with open(json_file, 'r') as f:
        data = json.load(f)

    do_upload(qloud, args, data)


command = edit
__ALL__ = ['command']
