import json
import time

import humanfriendly


def do_upload(qloud, args, new_environment):
    env_id = args['ENVIRONMENT_ID']

    if not args['--yes']:
        if not humanfriendly.prompts.prompt_for_confirmation('Do you want to proceed?'):
            return

    version = qloud.upload(env_id, new_environment)['version']
    print 'Upload completed. Version {} committed'.format(version)

    if '--wait' in args:
        print 'Waiting for deployment {}'.format(version)

        while True:
            time.sleep(5)
            status = qloud.get_environment_status(env_id, version)
            try:
                print status['status'], ('' + status['statusMessage']).replace("\n", " ")
                if status['status'] in ['DEPLOYED', 'FAILED']:
                    return
            except KeyError:
                pass


def upload(qloud, args):
    env_id = args['ENVIRONMENT_ID']
    json_file = args['FILE']

    print 'Uploading {FILE} to environment {ENVIRONMENT_ID}'.format(**args)

    with open(json_file, 'r') as f:
        new_environment = json.load(f)
        new_environment['objectId'] = env_id

    do_upload(qloud, args, new_environment)


command = upload
__ALL__ = ['command', 'do_upload']
