"""qloudctl

    Usage:
        qloudctl upload FILE to ENVIRONMENT_ID [--internal | --external] [--wait] [--yes]
        qloudctl dump ENVIRONMENT_ID to FILE [--internal | --external]
        qloudctl edit ENVIRONMENT_ID [--internal | --external] [--wait] [--yes]

    Options:
        --internal  Use qloud.yandex-team.ru [default]
        --external  Use qloud-ext.yandex-team.ru
        --wait      Wait for process completion
        --yes       Don't ask anything, just do it!

"""

from importlib import import_module

from docopt import docopt

import api


def main():
    args = docopt(__doc__, version="qloudctl")

    installation = 'qloud.yandex-team.ru'
    if args['--external']:
        installation = 'qloud-ext.yandex-team.ru'

    try:
        del args['--internal']
        del args['--external']
        del args['to']
        del args['from']
    except KeyError:
        pass

    qloud = api.Qloud(hostname=installation)

    for cmd in ['dump', 'edit', 'upload']:
        if cmd in args and args[cmd]:
            return import_module('commands.{}'.format(cmd)).command(qloud, args)


if __name__ == '__main__':
    main()
