import os
import socket

from lib.utils.configutil import get_env_var

# a tuple of (hostname/ip, port)
WSGI_LISTEN_ADDRESS = ("127.0.0.1", 5000)

SWAGGER_UI_OAUTH_CLIENT_ID = 'ee80fd7085d7436bba9f18bf71253c45'
SWAGGER_UI_OAUTH_APP_NAME = 'Q-Notifier API access'
SWAGGER_UI_DOC_EXPANSION = 'list'
SWAGGER_UI_JSON_EDITOR = True
SWAGGER_UI_REQUEST_DURATION = True
# EXPLAIN_TEMPLATE_LOADING = True

# EMAIL_MAX_RECIPIENTS = 50


# =====================================================================
# builtin flask configuration options go below, see
# http://flask.pocoo.org/docs/0.10/config/#builtin-configuration-values
# =====================================================================

# enable/disable debug mode
# DEBUG

# enable/disable testing mode
TESTING = get_env_var('QNOTIFIER_TESTING', 'yes') == 'yes'

# explicitly enable or disable the propagation of exceptions. If not set or
# explicitly set to None this is implicitly true if either TESTING or DEBUG
# is true.
# PROPAGATE_EXCEPTIONS

# By default if the application is in debug mode the request context is not
# popped on exceptions to enable debuggers to introspect the data. This can
# be disabled by this key. You can also use this setting to force-enable
# it  for non debug execution which might be useful to debug production
# applications (but also very risky).
# PRESERVE_CONTEXT_ON_EXCEPTION

# the secret key
# SECRET_KEY

# the name of the session cookie
# SESSION_COOKIE_NAME

# the domain for the session cookie. If this is not set, the cookie
# will be valid for all subdomains of SERVER_NAME.
# SESSION_COOKIE_DOMAIN

# the path for the session cookie. If this is not set the cookie
# will be valid for all of APPLICATION_ROOT or if that is not set for '/'.
# SESSION_COOKIE_PATH

# controls if the cookie should be set with the httponly flag.
# Defaults to True.
# SESSION_COOKIE_HTTPONLY

# controls if the cookie should be set with the secure flag.
# Defaults to False.
# SESSION_COOKIE_SECURE

# the lifetime of a permanent session as datetime.timedelta object.
# Starting with Flask 0.8 this can also be an integer representing seconds.
# PERMANENT_SESSION_LIFETIME

# enable/disable x-sendfile
# USE_X_SENDFILE

# the name of the logger
# LOGGER_NAME

# the name and port number of the server. Required for subdomain support
# (e.g.: 'myapp.dev:5000') Note that localhost does not support subdomains
# so setting this to "localhost" does not help. Setting a SERVER_NAME also
# by default enables URL generation without a request context but with
# an application context.
# SERVER_NAME = 'qnotifier-test.yandex-team.ru'

# If the application does not occupy a whole domain or subdomain this
# can be set to the path where the application is configured to live.
# This is for session cookie as path value. If domains are used, this
# should be None.
# APPLICATION_ROOT

# If set to a value in bytes, Flask will reject incoming requests with
# a content length greater than this by returning a 413 status code.
# MAX_CONTENT_LENGTH

# Default cache control max age to use with send_static_file() (the default
# static file handler) and send_file(), in seconds. Override this value
# on a per-file basis using the get_send_file_max_age() hook on Flask
# or Blueprint, respectively. Defaults to 43200 (12 hours).
# SEND_FILE_MAX_AGE_DEFAULT

# If this is set to True Flask will not execute the error handlers of HTTP
# exceptions but instead treat the exception like any other and bubble
# it through the exception stack. This is helpful for hairy debugging
# situations where you have to find out where an HTTP exception
# is coming from.
# TRAP_HTTP_EXCEPTIONS

# Werkzeug's internal data structures that deal with request specific data
# will raise special key errors that are also bad request exceptions.
# Likewise many operations can implicitly fail with a BadRequest exception
# for consistency. Since it's nice for debugging to know why exactly
# it failed this flag can be used to debug those situations. If this
# config is set to True you will get a regular traceback instead.
# TRAP_BAD_REQUEST_ERRORS

# The URL scheme that should be used for URL generation if no URL scheme
# is available. This defaults to http.
# PREFERRED_URL_SCHEME

# By default Flask serialize object to ascii-encoded JSON. If this is set
# to False Flask will not encode to ASCII and output strings as-is and
# return unicode strings. jsonfiy will automatically encode it in utf-8
# then for transport for instance.
# JSON_AS_ASCII

# By default Flask will serialize JSON objects in a way that the keys
# are ordered. This is done in order to ensure that independent of the
# hash seed of the dictionary the return value will be consistent to not
# trash external HTTP caches. You can override the default behavior
# by changing this variable. This is not recommended but might give you
# a performance improvement on the cost of cachability.
# JSON_SORT_KEYS

# If this is set to True (the default) jsonify responses will be pretty
# printed if they are not requested by an XMLHttpRequest object (controlled
# by the X-Requested-With header)
# JSONIFY_PRETTYPRINT_REGULAR

SQLALCHEMY_TRACK_MODIFICATIONS = False
SQLALCHEMY_RECORD_QUERIES = True  # debug
SQLALCHEMY_POOL_SIZE = 2
SQLALCHEMY_MAX_OVERFLOW = 1
SQLALCHEMY_POOL_TIMEOUT = 120

DB_USERNAME = get_env_var('QNOTIFIER_POSTGRE_USERNAME')
DB_PASSWORD = get_env_var('QNOTIFIER_POSTGRE_PASSWORD')
DB_ROOTCERT = get_env_var('QNOTIFIER_POSTGRE_CERT', '/qnotifier/root.crt')
FQDN = socket.getfqdn()
DC = FQDN[:3]  # hack to detect current DC

OAUTH_YANDEX_TOKEN = get_env_var('STAFF_OAUTH')
OAUTH_TELEGRAM_TOKEN = get_env_var('OAUTH_TELEGRAM_TOKEN')
# TODO: move flag to config
USE_TELEGRAM = OAUTH_TELEGRAM_TOKEN is not None

if TESTING:
    SWAGGER_UI_OAUTH_REDIRECT_URI = 'https://qnotifier-test.yandex-team.ru/ui/oauth2-redirect.html'
    LOGBROKER_TOPIC = 'q-notifier-dev--messages'
    LOGBROKER_PRODUCER_ID = 2002140
    LOGBROKER_CONSUMER_ID = 2002138
    DB_HOSTS = ['sas-k0r42e12sb4otxq4.db.yandex.net',
                'man-d26uchg4uxnkw6cz.db.yandex.net',
                'vla-ydxufkwb74fae7ne.db.yandex.net',
                ]
    DB_NAME = 'test_qnotifier_db'
else:
    SWAGGER_UI_OAUTH_REDIRECT_URI = 'https://qnotifier.yandex-team.ru/ui/oauth2-redirect.html'
    LOGBROKER_TOPIC = 'q-notifier-dev--prod-messages'
    LOGBROKER_PRODUCER_ID = 2002468
    LOGBROKER_CONSUMER_ID = 2002470
    DB_HOSTS = ['sas-v1u6oyzr8lrvxc4r.db.yandex.net',
                'man-l81dbflpy5abcow9.db.yandex.net',
                'vla-sz20y68haubmasvu.db.yandex.net',
                ]
    DB_NAME = 'prod_qnotifier_db'

DB_HOSTS.sort(key=lambda host: not host.startswith(DC))
DB_HOSTS_STRING = ','.join(DB_HOSTS)
DB_BASE_URI = (
                  'postgresql://%s:%s@%s/%s'
                  '?client_encoding=utf8'
                  '&port=6432,6432,6432'
                  '&sslmode=verify-full'
                  '&sslrootcert=%s'
              ) % (DB_USERNAME, DB_PASSWORD, DB_HOSTS_STRING, DB_NAME, DB_ROOTCERT)
SQLALCHEMY_DATABASE_URI = DB_BASE_URI + '&target_session_attrs=read-write'
SQLALCHEMY_BINDS = {
    'master': SQLALCHEMY_DATABASE_URI,
    'slave': DB_BASE_URI,
}

# http://urllib3.readthedocs.org/en/latest/helpers.html#urllib3.util.retry.Retry
BLACKBOX_RETRY_PARAMS = dict(
    total=10,
    status_forcelist=frozenset((400, 404, 500, 502, 503)),
    backoff_factor=0.01
)
# in seconds
BLACKBOX_TIMEOUT = 3
BLACKBOX_URI = 'https://blackbox.yandex-team.ru/blackbox'
RENEW_AUTH_COOKIE_URI = 'https://pass.yandex-team.ru/resign'

STAFF_URI = 'https://staff-api.yandex-team.ru/v3'
# in seconds
STAFF_TIMEOUT = 6

OAUTH_TOKEN_URL = 'https://oauth.yandex-team.ru/token'

# QNOTIFIER_ALLOWED_CLIENTS - comma-separated list of allowed client TVM ids
AUTHORIZER = {
    'client_id': 2002376,
    'secret': get_env_var('QNOTIFIER_TVM_SECRET'),
    'allowed_clients': tuple(
        map(int,
            filter(None,
                   get_env_var('QNOTIFIER_ALLOWED_CLIENTS', '').split(',')
                   )
            )
    ),
    'oauth_client_id': 'ee80fd7085d7436bba9f18bf71253c45',
    'oauth_client_secret': get_env_var('QNOTIFIER_OAUTH_SECRET'),
}

EVENTS = [
    {
        'classname': 'QloudSource',
        'options': {},
    }
]

GROUPS = [
    {
        'classname': 'AbcGroups',
        'options': {
            'oauth': OAUTH_YANDEX_TOKEN,
            'async': True,
        },
    },
    {
        'classname': 'StaffGroups',
        'options': {
            'oauth': OAUTH_YANDEX_TOKEN,
            'async': True,
        },
    },
]

USERS = [
    {
        'classname': 'UserCache',
        'options': {},
    },
    {
        'classname': 'StaffUsers',
        'options': {
            'oauth': OAUTH_YANDEX_TOKEN,
        },
    },
]

QUEUE = {
    'classname': 'LogbrokerQueue',
    'options': {
        'client_id': LOGBROKER_PRODUCER_ID,
        'service_id': 2001059,
        'source_id': b'%s:%d' % (FQDN.encode('utf-8'), os.getpid()),
        'secret': get_env_var('LOGBROKER_QNOTIFIER_PRODUCER_SECRET'),
        'host': 'lbkx.logbroker.yandex.net',
        'port': 2135,
        'topic': LOGBROKER_TOPIC,
    },
}

SUBSCRIPTIONS = {
    'classname': 'SubscriptionsCache',
    'options': {},
}

# =======
# LOGGING
# =======

LOGGING = {
    "formatters": {
        "detailed": {
            "()": "lib.utils.logging.ColoredFormatter",
            "fmt": "%(asctime)s %(process)s %(levelname)s %(name)s   %(message)s",
            "fmtAsctime": "[%(datetime)s.%(msecs)003d]",
            "fmtLevelname": "[%(levelname)-5s]",
            "fmtName": "[%(name)-21s]",
            "fmtProcess": "[%(process)-6s]",
            "hungryLevels": {
                "debug": ["message"],
                "error": ["message", "name"],
                "info": ["message"],
                "warning": ["message"],
            },
        },
        "skynet": {
            "()": "lib.utils.logging.ExtendedFormatter",
            "fmt": "%(process)s %(message)s",
            "fmtProcess": "[%(process)-6s]",
        }
    },
    "handlers": {
        "console": {
            "class": "logging.StreamHandler",
            "formatter": "detailed",
            "level": "INFO",
        },
    },
    "loggers": {
        "": {
            "handlers": ["console"],
            "level": "INFO",
        },
        "flask.app": {
            "propagate": True,
            "level": "DEBUG",
        },
        "gunicorn": {
            "propagate": True,
            "handlers": [],
        },
        "gunicorn.error": {
            "propagate": True,
            "handlers": [],
        },
        "gunicorn.access": {
            "propagate": True,
            "handlers": [],
        },
        "sqlalchemy.engine": {
            "propagate": True,
            "handlers": [],
            "level": "WARN",
        },
        "alembic": {
            "propagate": True,
            "handlers": [],
            "level": "INFO",
        },
        "qn": {
            "propagate": True,
            "handlers": [],
            "level": "DEBUG",
        }
    },
    "levelNameScheme": 1,
    "version": 1,
}

LOGGER_SOCKET_PATH = get_env_var('LOGGER_SOCKET_PATH')
if LOGGER_SOCKET_PATH:
    LOGGING['handlers']['skynet'] = {
        "class": "lib.skynet_logger.SkynetLoggingHandler",
        "formatter": "skynet",
        "level": "DEBUG",
        "app": "qnotifier-server",
        "filename": "qnotifier-server.log",
        "udp_socket_path": LOGGER_SOCKET_PATH,
    }
    LOGGING['loggers']['']['handlers'].append('skynet')


NOTIFIERS = [
                'email',
                # 'telegram',
            ] + (
                ['telegram'] if OAUTH_TELEGRAM_TOKEN else []
            )

# ============
# QUEUE WORKER
# ============

# FIXME it's in this config rather than config_worker
# because EmbeddedQueue uses the same config
WORKER = {
    "notifiers": [
                     {
                         'classname': 'EmailNotifier',
                         'options': {
                             'default_subject': 'Alert from Qnotifier',
                             'smtp': 'outbound-relay.yandex.net',
                         },
                     },
                 ] + (
                     [
                         {
                             'classname': 'TelegramNotifier',
                             'options': {
                                 'api_key': OAUTH_TELEGRAM_TOKEN,
                             },
                         },
                     ] if USE_TELEGRAM else []
                 ),
}
