DEBUG = True

SWAGGER_UI_OAUTH_REDIRECT_URI = 'http://localhost:5000/ui/oauth2-redirect.html'

SQLALCHEMY_DATABASE_URI = 'sqlite:///example.sqlite'
SQLALCHEMY_BINDS = None
SQLALCHEMY_POOL_SIZE = None
SQLALCHEMY_MAX_OVERFLOW = None
SQLALCHEMY_POOL_TIMEOUT = None

# use MUST to disable authorizer, because blackbox would forbid requests from your localhost
AUTHORIZER = None

QUEUE = {
    'classname': 'EmbeddedQueue',
    'options': {},
}

LOGGING = {
    "formatters": {
        "detailed": {
            "()": "lib.utils.logging.ColoredFormatter",
            "fmt": "%(asctime)s %(levelname)s %(name)s   %(message)s",
            "fmtAsctime": "%(datetime)s.%(msecs)003d",
            "fmtLevelname": "[%(levelname)-1s]",
            "fmtName": "[%(name)-21s]",
            "hungryLevels": {
                "debug": ["message"],
                "error": ["message", "name"],
                "info": ["message"],
                "warning": ["message"],
            },
        },
    },
    "handlers": {
        "console": {
            "class": "logging.StreamHandler",
            "formatter": "detailed",
            "level": "DEBUG",
        },
    },
    "loggers": {
        "": {
            "handlers": ["console"],
            "level": "DEBUG",
        },
        "gunicorn": {
            "propagate": True,
            "handlers": [],
        },
        "gunicorn.error": {
            "propagate": True,
            "handlers": [],
        },
        "gunicorn.access": {
            "propagate": True,
            "handlers": [],
        },
        "sqlalchemy.engine": {
            "level": "DEBUG",
        },
    },
    "levelNameScheme": 1,
    "version": 1,
}
