import os
import socket
from .config import *  # noqa


WSGI_LISTEN_ADDRESS = ("::", 5002)

SQLALCHEMY_BINDS = None

BOT = {
    'api_key': OAUTH_TELEGRAM_TOKEN,
    'lock': {
        'backend': 'yt',
        'proxy': 'locke',
        'token': get_env_var('QNOTIFIER_YT_TOKEN'),
        'prefix': '//home/qnotifier',
        'acquire_timeout': 120,
    }
}

LOGGING = {
    "formatters": {
        "detailed": {
            "()": "lib.utils.logging.ColoredFormatter",
            "fmt": "%(asctime)s %(levelname)s %(name)s   %(message)s",
            "fmtAsctime": "%(datetime)s.%(msecs)003d",
            "fmtLevelname": "[%(levelname)-1s]",
            "fmtName": "[%(name)-21s]",
            "hungryLevels": {
              "debug": ["message"],
              "error": ["message", "name"],
              "info": ["message"],
              "warning": ["message"],
            },
        },
        "skynet": {
            "()": "lib.utils.logging.ExtendedFormatter",
            "fmt": "%(process)s %(message)s",
            "fmtProcess": "[%(process)-6s]",
        },
    },
    "handlers": {
        "console": {
            "class": "logging.StreamHandler",
            "formatter": "detailed",
            "level": "DEBUG",
        },
    },
    "loggers": {
        "": {
            "handlers": ["console"],
            "level": "DEBUG",
        },
    },
    "levelNameScheme": 1,
    "version": 1,
}

if LOGGER_SOCKET_PATH:
    LOGGING['handlers']['skynet'] = {
        "class": "lib.skynet_logger.SkynetLoggingHandler",
        "formatter": "skynet",
        "level": "DEBUG",
        "app": "telegram-bot",
        "filename": "telegram-bot.log",
        "udp_socket_path": LOGGER_SOCKET_PATH,
    }
    LOGGING['loggers']['']['handlers'].append('skynet')
