from .config_worker import *

WSGI_LISTEN_ADDRESS = ("::", 5001)

LOGGING = {
    "formatters": {
        "detailed": {
            "()": "lib.utils.logging.ColoredFormatter",
            "fmt": "%(asctime)s %(levelname)s %(name)s   %(message)s",
            "fmtAsctime": "%(datetime)s.%(msecs)003d",
            "fmtLevelname": "[%(levelname)-1s]",
            "fmtName": "[%(name)-21s]",
            "hungryLevels": {
              "debug": ["message"],
              "error": ["message", "name"],
              "info": ["message"],
              "warning": ["message"],
            },
        },
        "skynet": {
            "()": "lib.utils.logging.ExtendedFormatter",
            "fmt": "%(process)s %(message)s",
            "fmtProcess": "[%(process)-6s]",
        },
    },
    "handlers": {
        "console": {
            "class": "logging.StreamHandler",
            "formatter": "detailed",
            "level": "DEBUG",
        },
    },
    "loggers": {
        "": {
            "handlers": ["console"],
            "level": "DEBUG",
        },
    },
    "levelNameScheme": 1,
    "version": 1,
}

if LOGGER_SOCKET_PATH:
    LOGGING['handlers']['skynet'] = {
        "class": "lib.skynet_logger.SkynetLoggingHandler",
        "formatter": "skynet",
        "level": "DEBUG",
        "app": "message-sender",
        "filename": "message-sender.log",
        "udp_socket_path": LOGGER_SOCKET_PATH,
    }
    LOGGING['loggers']['']['handlers'].append('skynet')
