import os
import socket
from .config import *  # noqa


WSGI_LISTEN_ADDRESS = ("::", 5001)

SQLALCHEMY_BINDS = None

if TESTING:
    LOGBROKER_CONSUMER = b'q-notifier-dev-consumer'
else:
    LOGBROKER_CONSUMER = b'q-notifier-dev/q-notifier-prod-consumer'

PQ = {
    'server': {
        'host': 'lbkx.logbroker.yandex.net',
        'port': 2135,
        'topic': LOGBROKER_TOPIC,
    },
    'writer': {
        'client_id': LOGBROKER_PRODUCER_ID,
        'service_id': 2001059,
        'secret': os.getenv('LOGBROKER_QNOTIFIER_PRODUCER_SECRET', 'PUT_YOUR_TOKEN_HERE'),
        'source_id': socket.getfqdn().encode('utf-8') + b'-worker',
    },
    'reader': {
        'client_id': LOGBROKER_CONSUMER_ID,
        'service_id': 2001059,
        'secret': os.getenv('LOGBROKER_QNOTIFIER_CONSUMER_SECRET', 'PUT_YOUR_TOKEN_HERE'),
        'consumer_id': LOGBROKER_CONSUMER,
    },
}
