import threading


class Controller(object):
    @classmethod
    def create(cls, options):
        """
        Create new instance of controller, using options from config

        :param dict options: any configuration vars
        :rtype: cls
        """
        return

    def key(self):
        """
        Get id used for this controller in configs etc.

        :rtype: str
        """
        return ''

    def name(self):
        """
        Get display name used for this controller in interfaces

        :rtype: str
        """
        return ''

    def spawn(self, task, *args, **kwargs):
        """
        Spawn thread with task
        """
        t = threading.Thread(target=task, args=args, kwargs=kwargs, daemon=True)
        t.start()

    def stop(self):
        """
        Stop controller
        """
