from ..controller import Controller


class Event(object):
    def __init__(self, message, params, source, tags, forced_users):
        self.message = message
        self.params = params
        self.source = source
        self.tags = tags
        self.forced_users = forced_users


class EventSource(Controller):
    def parse_event(self, data):
        """
        Make event from arbitrary data, received from external source

        :param dict data: dict with some data specific to this source
        :rtype: Event or None
        :return: opaque object that should be passed to other methods of this class
        """
        pass

    def make_message(self, event):
        """
        Make a notification message from the event.

        :param Event event: some object got from :meth:`~.EventSource.parse_event`
        :rtype: tuple(str, dict)
        :return: message and some additional optional parameters that can be used by some notifiers
        """
        pass
