from .abstract import EventSource, Event


class QloudSource(EventSource):
    @classmethod
    def create(cls, options):
        # FIXME
        return cls()

    def key(self):
        return 'qloud'

    def name(self):
        return "Qloud"

    def parse_event(self, data):
        if not isinstance(data, dict):
            return

        if 'message' not in data or 'tags' not in data:
            return

        return Event(
            message=data['message'],
            source=self,
            tags=data['tags'],
            params={
                key: value
                for key, value in data.get("extra", {}).items()
            },
            forced_users=data.get('forced-users') or [],
        )

    def make_message(self, event):
        return event.message, event.params
