from kikimr.public.sdk.python.persqueue.auth import TVMCredentialsProvider
from kikimr.public.sdk.python.persqueue.grpc_pq_streaming_api import (
    ConsumerConfigurator, ProducerConfigurator,
    PQStreamingAPI
)

from .tvm import make_tvm


def make_provider(config, label):
    tvm = make_tvm(config['client_id'], config['secret'], config['service_id'], label=label)
    return TVMCredentialsProvider(
        tvm,
        destination_client_id=config['service_id'],
    )


class PQClient(object):
    def __init__(self, pq_config, reader_config=None, writer_config=None):
        self.pq_config = pq_config
        self.reader_config = reader_config
        self.writer_config = writer_config
        self.reader_provider = None
        self.writer_provider = None
        self.api = PQStreamingAPI(pq_config['host'], pq_config['port'])

    def start(self):
        return self.api.start()

    def create_reader(self):
        assert self.reader_config is not None, "reader config is not provided"

        if self.reader_provider is None:
            self.reader_provider = make_provider(self.reader_config, "reader_provider")

        # TODO currently MaxUncommittedCount is not available in python,
        # should be set to something low like max_uncommitted_count=10
        reader_config = ConsumerConfigurator(
            topics=(self.pq_config['topic'],),
            client_id=self.reader_config['consumer_id'],
            read_only_local=True,
            use_client_locks=True,
            max_count=1,
            read_infly_count=1,
        )
        return self.api.create_consumer(reader_config, self.reader_provider)

    def create_writer(self):
        assert self.writer_config is not None, "writer config is not provided"

        if self.writer_provider is None:
            self.writer_provider = make_provider(self.writer_config, "writer_provider")

        writer_config = ProducerConfigurator(
            topic=self.pq_config['topic'],
            source_id=self.writer_config['source_id'],
        )
        return self.api.create_producer(writer_config, self.writer_provider)

    def stop(self):
        self.api.stop()

    def __del__(self):
        self.stop()
