from ..controller import Controller


class NotifyException(Exception):
    pass


class Notifier(Controller):
    def read_user_address(self, data):
        """
        Parse user authentication address from data read from storage

        :param dict data: any notifier-related properties from storage
        :rtype: object or None
        :return: some address that can be notified by this very notifier
        """
        pass

    def notify_user(self, message):
        """
        Send some message to custom address.

        :param object address: address belonging to this notifier
        :param object message: message with options to send
        :return object: message remainder if only part has been sent
        :raises NotifyException: if notification failed for some reason
        """
        pass
