from ..controller import Controller


class Subscriptions(Controller):
    def subscribers_for(self, tags):
        """
        Get groups and users subscribed to the specified set of tags

        :param iterator[str] tags: all tags listed in event, tag is negated if prefixed with '!'
        :rtype: tuple[dict[str, dict[str, dict[str, str]]], dict[str, dict[str, dict[str, str]]]]
        :return: pair (for users and groups) of maps of name -> [kind -> [key -> value]]
        """

    def update_settings_for(self, name, is_group, settings, replace_all):
        """
        Set subscription settings for user or group

        :param str name: user or group name
        :param bool is_group: flag, if name is group name
        :param dict[str, dict[str, str]] settings: mapping of notifier_id to map of key-value settings
        :param replace_all -- to be defined
        """

    def subscriptions_for_user(self, login):
        """
        Get subscriptions for user

        :param str login: user login
        :rtype: list[tuple[list[str], dict[str, dict[str, str]]]]
        :return: list of pairs of subscription and its settings
        """

    def subscriptions_for_group(self, name):
        """
        Get subscription for group

        :param str name: group name
        :rtype: list[tuple[list[str], dict[str, dict[str, str]]]]
        :return: list of pairs of subscription and its settings
        """

    def add_subscription(self, name, is_group, tags, settings):
        """
        Add subscription for user or group

        :param str name: user or group name
        :param bool is_group: flag, if name is group name
        :param list[str] tags: list of tags, negative ones are prefixed with '!'
        :param dict[str, dict[str, str]] settings: mapping of notifier_id to map of key-value settings for subscription
        :rtype: int
        :return: new subscription id
        :raises ValueError: if desired set of tags is already added for user
        """

    def remove_subscription(self, name, is_group, tags):
        """
        Remove subscription for user or group

        :param str name: user or group name
        :param bool is_group: flag, if name is group name
        :param list[str] tags: list of tags, negative ones are prefixed with '!'
        :raises KeyError: if subscription or name wasn't found
        """

    def update_subscription(self, name, is_group, tags, settings):
        """
        Add subscription for user or group

        :param str name: user or group name
        :param bool is_group: flag, if name is group name
        :param list[str] tags: list of tags, negative ones are prefixed with '!'
        :param dict[str, dict[str, str]] settings: mapping of notifier_id to map of key-value settings for subscription.
                                                   Keys with value None will be removed
        """

    def find_subscriptions_by_tags(self, tags, exact):
        """
        Find all subscriptions matching set of tags

        :param list[str] tags: list of tags, negative ones are prefixed with '!'
        :param bool exact: if set, only subscriptions with exact set of tags will be found,
                           otherwise there also would be found subscriptions where specified
                           tags are superset
        """
