import logging

from tvm2 import TVM2
from ticket_parser2.api.v1 import BlackboxClientId

LOG = logging.getLogger(__name__)


def make_tvm(client_id, secret, *destinations, prod=True, label=None):
    class TVM(TVM2):
        pass  # fu^W hack singleton

    if label is None:
        label = "n/a"

    blackbox_client_id = BlackboxClientId.Prod if prod else BlackboxClientId.ProdYateam
    LOG.info("make tvm for %s: client_id=%r, blackbox=%r, destinations=%r" % (
        label, client_id, blackbox_client_id, destinations))

    return TVM(
        client_id=client_id,
        secret=secret,
        blackbox_client=blackbox_client_id,
        destinations=destinations,
    )
