from ..controller import Controller


class User(object):
    def __init__(self, login):
        self.login = login
        self.infos = {}

    def set_address_for(self, notifier, address):
        self.infos[notifier] = address

    def get_address_for(self, notifier):
        """
        Get user info necessary for specific notifier type

        :param str notifier: notifier id
        :rtype: object or None
        :return: data to give to notifier for parsing
        """
        return self.infos.get(notifier)


class UserSource(Controller):
    def find_user(self, login):
        """
        Get user info by login name

        :param str login: user login name
        :rtype: User or None
        """
        pass

    def check_telegram_authentication(self, login):
        """
        Check if user is authenticated with telegram

        :param str login: user login name
        :rtype: bool
        """
        pass
