import flask

from .abstract import User, UserSource


class UserCache(UserSource):
    def __init__(self, db, log):
        self.db = db
        self.log = log

    @classmethod
    def create(cls, options, log):
        assert isinstance(options, dict), "options should be dict but %r" % (type(options),)
        db = flask.current_app.database_pool
        return cls(db, log.getChild('users.cache'))

    def key(self):
        return "user_cache"

    def name(self):
        return "Database user cache"

    def find_user(self, login):
        with self.db.connection() as conn, conn.cursor() as cur:
            cur.execute("SELECT login, email FROM users WHERE login = %s", (login,))
            info = cur.fetchone()

        if info is None:
            return

        user = User(login)
        user.set_address_for("email", {"email": info.email})
        return user

    def check_telegram_authentication(self, login):
        with self.db.connection() as conn, conn.cursor() as cur:
            query = "SELECT chat_id FROM tg_chats WHERE nickname = %s"
            cur.execute(query, (login,))
            row = cur.fetchone()
            return bool(row)
