import logging
import os

LOG = logging.getLogger(__name__)


def get_env_var(name, default=None):
    value = os.getenv(name)
    if value is None:
        LOG.warning("env variable not found: %s, fallback to default %r" % (name, default))
        value = default
    return value
