import sys
import termios


def is_terminal(fd=None):
    """
    Returns whether fd is a tty device
    """
    if fd is None:
        try:
            # BUG: I can replace sys.stdout with object with fileno() method [def fileno(self): return None]
            fd = sys.stdout.fileno()
        except AttributeError:  # stdout was replaced by some non-file object
            return False

    try:
        termios.tcgetattr(fd)
        return True
    except termios.error:
        return False
