"""initial revision

Revision ID: 19927794bc46
Revises:
Create Date: 2018-09-03 17:45:30.880776

"""
from alembic import op
import sqlalchemy as sa
import flask


# revision identifiers, used by Alembic.
revision = '19927794bc46'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    collation = 'BINARY' if flask.current_app.database.engine.url.drivername == 'sqlite' else 'en_US'
    op.create_table(
        'users',
        sa.Column('login', sa.VARCHAR(length=256, collation=collation), nullable=False, primary_key=True),
        sa.Column('email', sa.VARCHAR(length=256, collation=collation), nullable=True),
        postgresql_with_oids=False,
    )

    op.create_table(
        'tags',
        sa.Column('tag_id', sa.INTEGER(), nullable=False, primary_key=True, autoincrement=True),
        sa.Column('name', sa.VARCHAR(length=256, collation=collation), nullable=True),
        postgresql_with_oids=False,
    )
    op.create_index('tags__name', 'tags', ['name'], unique=1)

    op.create_table(
        'tg_chats',
        sa.Column('nickname', sa.VARCHAR(length=256, collation=collation), nullable=False, primary_key=True),
        sa.Column('chat_id', sa.VARCHAR(length=256, collation=collation), nullable=True),
        postgresql_with_oids=False,
    )
    op.create_index('tg_chats__chat_id', 'tg_chats', ['chat_id'], unique=1)

    op.create_table(
        'subscriptions',
        sa.Column('subscription_id', sa.INTEGER(), nullable=False, primary_key=True, autoincrement=True),
        sa.Column('rule', sa.Text(collation=collation), nullable=False),
        sa.Column('name', sa.VARCHAR(length=256, collation=collation), nullable=False),
        sa.Column('is_group', sa.Boolean(), nullable=False),
        sa.Column('positive_clauses', sa.SmallInteger(), nullable=False),
        sa.Column('negative_clauses', sa.SmallInteger(), nullable=False),
        postgresql_with_oids=False,
    )
    op.create_index('subscriptions__is_group', 'subscriptions', ['is_group'], unique=False)

    op.create_table(
        'subscriptions_tags',
        sa.Column('subscription_id', sa.INTEGER(),
                  sa.ForeignKey('subscriptions.subscription_id', ondelete='CASCADE'),
                  nullable=False, primary_key=True),
        sa.Column('tag_id', sa.INTEGER(), sa.ForeignKey('tags.tag_id', ondelete='CASCADE'),
                  nullable=False, primary_key=True),
        sa.Column('invert', sa.SmallInteger(), nullable=False, primary_key=True),
        postgresql_with_oids=False,
    )

    op.create_table(
        'settings',
        sa.Column('subscription_id', sa.INTEGER(),
                  sa.ForeignKey('subscriptions.subscription_id', ondelete='CASCADE'), nullable=True),
        sa.Column('name', sa.VARCHAR(length=256, collation=collation), nullable=False),
        sa.Column('is_group', sa.Boolean(), nullable=False),
        sa.Column('kind', sa.VARCHAR(length=256, collation=collation), nullable=False),
        sa.Column('setting', sa.VARCHAR(length=256, collation=collation), nullable=False),
        sa.Column('value', sa.Text(collation=collation), nullable=True),
        postgresql_with_oids=False,
    )
    op.create_index('settings_pkey', 'settings',
                    ['subscription_id', 'name', 'is_group', 'kind', 'setting'], primary_key=True)
    op.create_index('settings__subscription_id', 'settings', ['subscription_id'], unique=False)
    op.create_index('settings__is_group', 'settings', ['is_group'], unique=False)


def downgrade():
    op.drop_table('settings')
    op.drop_table('subscriptions_tags')
    op.drop_table('subscriptions')
    op.drop_table('tg_chats')
    op.drop_table('tags')
    op.drop_table('users')
