"""fix indices for settings

Revision ID: 75199d2342e2
Revises: 19927794bc46
Create Date: 2019-10-14 18:45:30.373323

"""
from alembic import op
import sqlalchemy as sa
import flask


# revision identifiers, used by Alembic.
revision = '75199d2342e2'
down_revision = '19927794bc46'
branch_labels = None
depends_on = None


def upgrade():
    if flask.current_app.database.engine.url.drivername == 'sqlite':
        return

    op.drop_index('settings_pkey', 'settings')
    op.create_index('settings_pkey_5f', 'settings',
                    ['subscription_id', 'name', 'is_group', 'kind', 'setting'],
                    unique=True,
                    postgresql_where=sa.text('settings.subscription_id IS NOT NULL'))
    op.create_index('settings_pkey_4f', 'settings',
                    ['name', 'is_group', 'kind', 'setting'],
                    unique=True,
                    postgresql_where=sa.text('settings.subscription_id IS NULL'))


def downgrade():
    if flask.current_app.database.engine.url.drivername == 'sqlite':
        return

    op.drop_index('settings_pkey_5f', 'settings')
    op.drop_index('settings_pkey_4f', 'settings')
    op.create_index('settings_pkey', 'settings',
                    ['subscription_id', 'name', 'is_group', 'kind', 'setting'], primary_key=True)
