from infra.qyp.account_manager.src.main import Application

try:
    import argparse
    from infra.swatlib import cmdutil
except KeyboardInterrupt:
    # don't bother user with python stack trace
    # if interrupted (by Ctrl+C) during imports
    raise SystemExit(1)


def init_arg_parser():
    p = argparse.ArgumentParser(description=Application.name)
    p.add_argument('-c', '--cfg',
                   default=None,
                   action='store', help='path to service cfg file')
    # --console is used to dump logs during debugging with IDE
    # when stdout isn't terminal but we don't want to log to file
    p.add_argument('--console',
                   default=False,
                   action='store_true',
                   help='redirect log to stdout (overrides config)')
    p.add_argument('-d', '--debug',
                   default=False,
                   action='store_true',
                   help='do NOT daemonize, do NOT change working dir')
    return p


def main():
    arg_parser = init_arg_parser()
    cmdutil.main(arg_parser, Application, env_prefix='QYP')


if __name__ == '__main__':
    main()
