HEADER_MESSAGE_OWNERS_POLLER = 'Changed owners on virtual machine ({})'
TEXT_MESSAGE_OWNERS_POLLER = """
Hello,

On virtual machine ({}) owners list has changed due to the dismissal employees or deactivation groups.
You received this email, because you are one of the owners this virtual machine.

Old owners: {}
New owners: {}
Old groups: {}
New groups: {}
"""

QYP_PERSONAL_ID = 'abc:service:4172'
DEFAULT_EMAIL_CONFIG = {'server': 'localhost', 'default_sender': 'robot-vmagent-rtc@yandex-team.ru',
                        'port': 25}
SLEEP_SECS = 60 * 60 * 24
STAFF_STEP_REQUEST = 200
REMOVE_ACCOUNT_IDS_METRICS = frozenset(['odin', 'replication-common-account'])
DEV_SEGMENT_ID = 'dev'
TEMPORARY_ACCOUNT_ID = 'tmp'
ABC_ACCOUNT_SCOPES = ['8', '90', '1']  # [administration, quota_management, service_management]

ONE_TB = 1024 ** 4
COUNT_DAYS_MOVE_STATE_1 = 30
COUNT_DAYS_MOVE_STATE_2 = 14
COUNT_DAYS_MOVE_STATE_3 = 13
COUNT_DAYS_MOVE_STATE_4 = 1
PERIOD = 24 * 60 * 60
DEFAULT_DAYS = 31
QYP_LINK_TMPL = 'https://qyp.yandex-team.ru/vm/{}/{}/'
UNUSED_VM_LABEL_NAME = 'unused_for_30_days'
DOCS_LINK_FOR_UNUSED = 'https://docs.yandex-team.ru/qyp/unused-vms'

HEADER_MESSAGE_UNUSED_VMS = 'QYP. Notification about automatic VM deallocation: {}'
TEXT_MESSAGE_UNUSED_VMS_STEP_1 = """
Your QYP {vm_id} VM {qyp_link} has not been in use for 30 days.
If you have no plans for using this VM, please remove it via QYP UI or QYP cli tool.
We will delete this VM if it is not used for another 30 days ({date}).

Learn more about this process: {wiki_link}

We sent this email to all owners of the VM: {owners}.
"""
TEXT_MESSAGE_UNUSED_VMS_STEP_2 = """
Your QYP {vm_id} VM {qyp_link} has not been in use for 45 days.
If you have no plans for using this VM, please remove it via QYP UI or QYP cli tool.
We will delete this VM if it is not used for another 14 days ({date}).

Learn more about this process: {wiki_link}

We sent this email to all owners of the VM: {owners}.
"""
TEXT_MESSAGE_UNUSED_VMS_STEP_3 = """
Your QYP {vm_id} VM {qyp_link} has not been in use for 60 days.
We will delete this VM tomorrow ({date}) if it is not used.

Learn more about this process: {wiki_link}

We sent this email to all owners of the VM: {owners}.
"""
TEXT_MESSAGE_UNUSED_VMS_STEP_5 = """
Your QYP {vm_id} VM has been removed due to inactivity for 60 days.
All data from VM was backed up:
{backup_url}
You can use this url when creating a new VM

Learn more about this process: {wiki_link}

We sent this email to all owners of the VM: {owners}.
"""


TICKET_IGNORED_REMINDER_TIME = 60 * 60 * 24 * 30
ROOT_FOLLOWER = 'frolstas'

dismissed_user_ticket_title = "Исправить информацию о владельцах вм сервиса {abc_name}"
dismissed_user_ticket_content_start = """
Виртуальные машины сервиса https://abc.yandex-team.ru/services/{abc_id} не соответствуют требованиям:

"""

dismissed_vm_in_abc_start = """
<{{ {vm_id}
((https://qyp.yandex-team.ru/vm/{cluster}/{vm_id} {vm_id}))
"""

dissmissed_users_text = """Бывшие сотрудники
- %%{list}%%
"""

non_account_users_text = """Среди владельцев нет ни одного пользователя, имеющего доступ к квоте. Сотрудники без доступа к квоте, в которой заведена ВМ
- %%{list}%%
"""
deleted_groups_text = """Группы staff/сервисы ABC, которые больше не существуют
- %%{list}%%
"""

dissmissed_users_exception_text = """
Если вышеуказанные пользователи/группы были добавлены в список намеренно, и исправление не требуется, добавьте ВМ в исключения,
перейдя по https://xdc.qyp.yandex-team.ru/add_vm_exception_form?vm_id={vm_id}&cluster={cluster}
}}>
"""

dismissed_user_ticket_content_end = """
Нужно исправить проблемы, убрав пользователей/группы из списка владельцев через UI/CLI.
Общие сведения о требованиях к заполнению списка владельцев ВМ можно почитать здесь https://wiki.yandex-team.ru/qyp/dismissed-vm-owners/.
Пожалуйста, не закрывайте этот тикет. Наша автоматика самостоятельно закроет тикет, когда проблемы будут устранены.

Тикет создан от имени робота, призывайте явно frolstas@, если у вас есть любые вопросы
"""

reminder_comment_text = "В этой задаче не было никаких изменений более 30 дней. Пожалуйста, займитесь ей."

dismissed_owner_blacklist_vms = 'dismissed_owner_blacklist_vms'
dismissed_vm_ticket_tag = 'validate_vm_permissions'

dismissed_owner_blacklist_form = """
<!DOCTYPE html>
<html>
    <body>
    <p style="font-size: large;">Add VM <b>{vm_id}</b> in cluster <b>{cluster}</b> to exceptions</p>
    <form action="/add_dismissed_owner_blacklist_vm" method="post"">
        <input type="submit" value="Add">
        <input type="hidden" id="vm_id" value="{vm_id}" name="vm_id">
        <input type="hidden" id="cluster" value="{cluster}" name="cluster">
    </form>
    </body>
</html>

"""
