class VMAgentParamsError(Exception):
    pass


class OperationError(Exception):
    """
    Some operation (like modification) failed.
    """
    pass


class AuthorizationError(OperationError):
    """
    Authorization settings dissallows this operation.
    """


class ConcurrentModificationError(OperationError):
    """
    Seems like compare-and-swap operation failed.
    """
    pass


class WrongStateError(OperationError):
    """
    Operation failed because entity is in incompatible state.
    """
    pass
