import time


def int_to_str_gigabytes(value):
    """
    :type value: int
    :return: int
    """
    return '{}G'.format(value / 1024 ** 3)


def int_to_gigabytes(value):
    """
    :param value: int
    :return: int
    """
    return value / 1024 ** 3


def diff_two_dict(first_dict, second_dict):
    """
    Difference values from the first and second dict and return new dict
    :param first_dict: dict[str, int]
    :param second_dict: dict[str, int]
    :return: dict[str, int]
    """
    result_dict = {}
    for key in first_dict.keys():
        result_dict[key] = first_dict[key] - second_dict[key]
    return result_dict


def sum_two_dict(first_dict, second_dict):
    """
    Difference values from the first and second dict and return new dict
    :param first_dict: dict[str, int]
    :param second_dict: dict[str, int]
    :return: dict[str, int]
    """
    result_dict = {}
    for key in first_dict.keys():
        result_dict[key] = first_dict[key] + second_dict[key]
    return result_dict


def make_dict_resources_bytes(cpu, mem, hdd, ssd, ip, multiply=1):
    """
    Make dict resource by byte
    :param cpu: int
    :param mem: int
    :param hdd: int
    :param ssd: int
    :param ip: int
    :param multiply: int
    :return: dict[str, str]
    """
    return {'CPU': cpu * multiply,
            'MEM': mem * multiply,
            'HDD': hdd * multiply,
            'SSD': ssd * multiply,
            'IPv4': ip * multiply}


def convert_dict_resources_bytes_to_str(dct):
    """
    Change type values byte in dict resources to str
    :param dct: dict[str, int]
    :return: dct[str, str]
    """
    return {'CPU': '{}'.format(dct['CPU'] / 1000),
            'MEM': '{}'.format(int_to_str_gigabytes(dct['MEM'])),
            'HDD': '{}'.format(int_to_str_gigabytes(dct['HDD'])),
            'SSD': '{}'.format(int_to_str_gigabytes(dct['SSD'])),
            'IPv4': '{}'.format(dct['IPv4'])}


def make_dict_resources(cpu, mem, hdd, ssd, ip, convert=True):
    """
    Make dict resource
    :param cpu: int
    :param mem: int
    :param hdd: int
    :param ssd: int
    :param ip: int
    :param convert: bool, default False
    :return: dict[str, str]
    """
    return {'CPU': '{}'.format(cpu / 1000 if convert else cpu),
            'MEM': '{}'.format(int_to_str_gigabytes(mem if convert else mem * 1024 ** 3)),
            'HDD': '{}'.format(int_to_str_gigabytes(hdd if convert else hdd * 1024 ** 3)),
            'SSD': '{}'.format(int_to_str_gigabytes(ssd if convert else ssd * 1024 ** 3)),
            'IPv4': '{}'.format(ip)}


def create_dict_usage_metrics():
    return {
        'cpu': 0,
        'mem': 0,
        'hdd': 0,
        'ssd': 0,
    }


def convert_dict_resources_to_protobuf(proto, dct):
    proto.cpu = dct['CPU']
    proto.memory = dct['MEM']
    proto.hdd = dct['HDD']
    proto.ssd = dct['SSD']
    proto.ip = dct['IPv4']


def get_et_st(period, days):
    """
    Get start and end timestamp by period on days
    :type period: int
    :type days: int
    :rtype: (int, int)
    """
    et = int(time.time()) - period
    st = et - period * days
    return et, st


def get_days_delta(t1, t2=None):
    """
    Get days between t1 and t2. t2 will be current time if not specified otherwise
    :type t1: int
    :type t2: int|None
    :rtype: int
    """
    t2 = time.time() if t2 is None else t2
    delta = (t2 - t1)/(24*60*60)
    return int(delta)


def quoted(items):
    for item in items:
        yield '"{}"'.format(item)
