from __future__ import unicode_literals

import flask

from nanny_rpc_client.proto import status_pb2
from infra.swatlib.rpc.blueprint import HttpRpcBlueprint as BaseHttpRpcBlueprint


class HttpRpcBlueprint(BaseHttpRpcBlueprint):
    def __init__(self, name, import_name, url_prefix, serialize_resp_threads_count=None,
                 validate_schema=True, infer_response_schema=True):

        super(HttpRpcBlueprint, self).__init__(name, import_name,
                                               url_prefix=url_prefix,
                                               status_msg=status_pb2.Status,
                                               validate_schema=validate_schema,
                                               infer_response_schema=infer_response_schema,
                                               serialize_resp_threads_count=serialize_resp_threads_count)

    def get_authenticator(self):
        return flask.g.ctx.rpc_authenticator
