import json
import kazoo.exceptions
import zlib


class ZkStorage(object):
    DATA_PATH = 'qyp_am_data'

    def _init_data_parent(self):
        if not self.parent_created:
            self.parent_created = True
            try:
                self.zookeeper.client.create(self.data_path, makepath=True)
            except kazoo.exceptions.NodeExistsError:
                pass

    def __init__(self, root, zk):
        self.data_path = '{}/{}'.format(root, self.DATA_PATH)
        self.zookeeper = zk
        self.parent_created = False

    def _get_data_path(self, data_id):
        return '{}/{}'.format(self.data_path, data_id)

    def get(self, data_id):
        self._init_data_parent()
        path = self._get_data_path(data_id)
        try:
            bytes_data, node_stat = self.zookeeper.client.get(path)
        except kazoo.exceptions.NoNodeError:
            return None
        decoded = self._deserialize(bytes_data)
        return json.loads(decoded)

    def set(self, json_data, data_id):
        self._init_data_parent()
        bytes_data = self._serialize(json_data)
        path = self._get_data_path(data_id)
        try:
            self.zookeeper.client.set(path, bytes_data)
        except kazoo.exceptions.NoNodeError:
            self.zookeeper.client.create(path, bytes_data)

    def _serialize(self, json_data):
        encoded = json.dumps(json_data).encode('utf-8')
        compressed = zlib.compress(encoded)
        return compressed

    def _deserialize(self, bytes_data):
        decompressed = zlib.decompress(bytes_data)
        decoded = decompressed.decode('utf-8')
        return decoded
