import gevent
import yp.data_model as data_model
from gevent.pool import Pool
from infra.qyp.account_manager.src import constant
from infra.qyp.account_manager.src import helpers
from infra.qyp.account_manager.src.lib import usage_calculator
from infra.qyp.account_manager.src.lib.gutils import idle_iter
from infra.qyp.account_manager.src.model import list_user_accounts
from infra.qyp.proto_lib import accounts_pb2
from sepelib.core import config


def get_account_summary(ctx, service_id, exclude_users, exclude_scopes, list_logins):
    """
    :type ctx: infra.qyp.account_manager.src.main.Ctx
    :type service_id: str
    :type exclude_users: list[str]
    :type exclude_scopes: list[str]
    :type list_logins: list[str]
    :rtype: accounts_pb2.PotentialResourceInfo
    """
    personal_quota_limit = config.get_value('personal_limit', None)
    spec = {'role__code': 'qyp_user'}

    if service_id:
        qyp_users = ctx.abc_client.list_service_members(service_id, spec=spec, remove_robot=True)
        if len(qyp_users) == 0:
            all_scopes = []
            for resp in ctx.abc_client.list_members_iter({'fields': 'role.code', 'service': service_id}):
                all_scopes.extend(resp['results'])
            unique_scopes = set(item['role']['code'] for item in all_scopes) - set(exclude_scopes)
            spec = {'role__code': unique_scopes}
            qyp_users = list(set(ctx.abc_client.list_service_members(service_id, spec=spec, remove_robot=True)))
    else:
        qyp_users = list_logins
    qyp_users = set(qyp_users) - set(exclude_users)

    request_permissions = ctx.yp_client_list[0].check_object_permissions_few(constant.QYP_PERSONAL_ID,
                                                                             data_model.OT_ACCOUNT,
                                                                             qyp_users, data_model.ACA_USE)
    qyp_users = [user for user, request in request_permissions if request == data_model.ACA_ALLOW]

    count_users = len(qyp_users)
    personal_limits = personal_quota_limit[constant.QYP_PERSONAL_ID]
    group_quota = helpers.make_dict_resources_bytes(personal_limits['cpu'],
                                                    personal_limits['mem'],
                                                    personal_limits['disk'][1]['capacity'],
                                                    personal_limits['disk'][0]['capacity'],
                                                    personal_limits['internet_address'],
                                                    count_users)

    rsp = accounts_pb2.PotentialResourceInfo()
    rsp.count_users = count_users

    requests = []

    pool = Pool(len(ctx.pod_ctl_map))
    threads = []

    def request(ctx_obj, qyp_users, segment, use_cache):
        requests.append(list_user_accounts.run(ctx=ctx_obj, logins=qyp_users, segment=segment, use_cache=use_cache))
    for pod_ctl in idle_iter(ctx.pod_ctl_map.values()):
        fake_ctx = list_user_accounts.FakeContext(ctx.abc_client, pod_ctl, personal_quota_limit)
        threads.append(pool.spawn(request, fake_ctx, qyp_users, 'dev', True))
    gevent.joinall(threads)

    group_quota_used = helpers.make_dict_resources_bytes(0, 0, 0, 0, 0)
    for user in idle_iter(qyp_users):
        accounts = []
        for req in requests:
            accounts.extend(req[1][user])
        help = usage_calculator.UsageCalculator(user)
        help.init(accounts)

        for service_id, usage in help.group_usage_stat.get_statistics().iteritems():
            helpers.convert_dict_resources_to_protobuf(rsp.users[user].group_cons[service_id], usage['dev'].to_dict())
        helpers.convert_dict_resources_to_protobuf(
            rsp.users[user].group_cons['summary'], help.group_usage_stat.get_group_usage().to_dict()
        )
        difference = helpers.make_dict_resources_bytes(0, 0, 0, 0, 0)
        for req in requests:
            for key, val in req[0][user].iteritems():
                if key == 'summary':
                    continue
                difference = helpers.sum_two_dict(difference, val)
                helpers.convert_dict_resources_to_protobuf(rsp.users[user].personal_vms[key],
                                                           helpers.convert_dict_resources_bytes_to_str(val))
        helpers.convert_dict_resources_to_protobuf(rsp.users[user].personal_vms['summary'],
                                                   help.personal_usage.to_dict())
        group_quota_used = helpers.sum_two_dict(group_quota_used, difference)
        group_quota_used = helpers.sum_two_dict(group_quota_used, help.group_usage_stat.get_group_usage().
                                                to_dict_byte())
        helpers.convert_dict_resources_to_protobuf(rsp.users[user].diff_pers_with_used,
                                                   help.get_available_usage().to_dict())

    diff_predict_with_used = helpers.diff_two_dict(group_quota, group_quota_used)
    helpers.convert_dict_resources_to_protobuf(rsp.used_quota,
                                               helpers.convert_dict_resources_bytes_to_str(group_quota_used))
    helpers.convert_dict_resources_to_protobuf(rsp.group_quota,
                                               helpers.convert_dict_resources_bytes_to_str(group_quota))
    helpers.convert_dict_resources_to_protobuf(rsp.diff_group_with_used,
                                               helpers.convert_dict_resources_bytes_to_str(diff_predict_with_used))
    return rsp
