# CLI

## Что это {#intro}

Инструкция по запуску виртуальных машин QEMU KVM при помощи Command Line Interface с аллокацией ресурсов через [YP](https://wiki.yandex-team.ru/yp/).


## Порядок действий {#steps}

1. Установить `vmctl` (инструкция [ниже](#vmctl-install)). `vmctl` также доступен через ya: `ya tool qyp`.
1. Опционально - [получить OAuth токен](#oauth). В случае его отсутствия, `vmctl` попробует получить его сам.
1. Собрать образ ВМ (или взять существующий), создать и запустить виртуальную машину с помощью `vmctl create`.

Ниже подробно описаны действия для запуска виртуальной машины.

## Подготовка {#prerequisites}

### Доступы

{% note alert %}

Убедитесь, что на хосте, с которого будут проводиться действия с виртуальной машиной, есть доступ до балансеров `{sas,man,vla}-swat.yandex-team.ru`, порты 80 и 443 (доступ есть для [@allstaff](https://staff.yandex-team.ru/allstaff)@, [проверка доступа в Puncher для локации man](https://puncher.yandex-team.ru/?destination=man-swat.yandex-team.ru&rules=exclude_rejected&values=all&sort=destination)).

{% endnote %}

* Если вы планируете использовать IDM+Cauth для управления доступами и доставки соотв. ключей в ВМ, то необходимо проверить, что от указанных вами при аллокации сетей есть доступ до сервера CAuth (cauth.yandex.net, порты: 389, 636, 4443). Список текущих дырок: <https://paste.yandex-team.ru/493508> [шаблон ссылки в puncher для cauth](https://puncher.yandex-team.ru?create_destinations=cauth.yandex.net&create_protocol=tcp&create_locations=office&create_locations=vpn&create_ports=389&create_ports=636&create_ports=4443&create_comment=Доступ%20до%20cauth) не забудьте указать свой макрос в поле источник.


### Установка vmctl {#vmctl-install}

* Готовые бинарники в Sandbox:
   * [Linux](https://sandbox.yandex-team.ru/resources?type=VMCTL_LINUX&state=READY)
   * [MacOS](https://sandbox.yandex-team.ru/resources?type=VMCTL_MACOS&state=READY)
   * [Windows](https://sandbox.yandex-team.ru/resources?type=VMCTL_WINDOWS&state=READY)
   
   Если исполняемый файл был скачан из Sandbox, его можно обновить до последней версии, выполнив `vmctl upgrade-vmctl` (не работает для ОС Windows).

* Сборка из исходного кода:
   Исходный код vmctl находится в Аркадии: <https://a.yandex-team.ru/arc/trunk/arcadia/infra/qyp/vmctl/>.

   ```bash
   $ ya make infra/qyp/vmctl --checkout
   $ cd <arcadia_root>/infra/qyp/vmctl
   $ ./bin/vmctl --help
   ```

* В составе утилиты ya - `ya tool qyp`


### Получение OAuth токена {#oauth}

Пользовательский OAuth токен можно получить, пройдя по этой [ссылке](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=d13a24721141492096c50ed35d33f8fd).


### Выбор образа виртуальной машины {#images}

Собрать образ VM HDD в sandbox или взять уже преднастроенные поисковые [подробнее](images-set.md).


## Использование vmctl {#vmctl-usage}

Список основных аргументов:
* `--cluster` — выбор локации, в которой будет создана виртуальная машина (доступны VLA, SAS, MAN). `--cluster` можно не указывать, если его можно вывести из контекста(например, если pod-id уникальны, то cluster можно вывести из pod-id).
* `--pod-id` — id виртуальной машины. После создания, можно будет выполнять действия с виртуальной машиной, используя этот id. Виртуальная машина получит сетевой адрес ` <id>.<cluster>.yp-c.yandex.net `. Есть следующие ограничения на формат id:
   * длина не более 30 символов
   * можно использовать строчные латинские буквы, цифры и тире (regex `^[a-z0-9\-]+$`)

{% note alert %}

Порядок аргументов важен! Основные аргументы должны быть указаны после команды.

{% endnote %}

Список доступных команд:
* `create` — создает и запускает виртуальную машину.
* `list` — список созданных ВМ.
* `status` — получает статус ВМ.
* `allocate` — создает pod (см документацию YP) для запуска в нем виртуальной машины.
* `deallocate` — удаляет pod, запущенная в нем ВМ будет остановлена и удалена.
* `config` — изменяет параметры конфигурации ВМ (размер памяти, количество ядер, образ ВМ).
* `update` — изменяет параметры ВМ.
* `start` — запускает ВМ.
* `monitor` — периодически получает статус ВМ с интервалом в 1 секунду.
* `shutdown` — выключает ВМ gracefully.
* `poweroff` — выключает ВМ (имитация отключения питания).
* `reset` — перезагрузка ВМ.
* `revert` — сброс к начальному состоянию диска и остановка.
* `rescue` — запуск в режиме восстановления.
* `list-accounts` — список потребления ресурсов в доступных пользователю квотах.

Список параметров каждой команды можно посмотреть, выполнив ` vmctl <command> --help `
Пример вызова команды `status`:


```bash
$ vmctl status --pod-id my-shiny-vm --cluster MAN
```

## Создание ВМ {#create}

Список параметров:
* `--network-id` — сетевой макрос из [Racktables](https://racktables.yandex-team.ru/index.php?page=services&tab=projects) для доступа к ВМ по сети.
    
    Если у вашего подразделения уже есть свой сетевой макрос, то имеет смысл использовать его — тогда дырки этого макроса будут работать и с вашей ВМ.
    
    Если вы не в курсе про сетевые макросы, то рекомендуется просто указывать макрос `_SEARCHSAND_` (<https://puncher.yandex-team.ru/?destination=_SEARCHSAND_&rules=exclude_rejected&values=all&sort=destination>).
    
    Если вы понимаете, что происходит и какая модель сетевого доступа вам нужна, то можете создать свой сетевой макрос [здесь](https://wiki.yandex-team.ru/NOC/newnetwork/hbf/projectid/project-id-allocation/#opisanieformy), прокрутить нужные дырки и использовать его для ВМ.
    
    {% note alert %}
    
    Пользователь, создающий ВМ, должен быть в списке владельцев выбранного макроса (это правило не касается `_SEARCHSAND_`).
    
    {% endnote %}

    Для доступа во внешний интернет нужна дырка в [puncher](https://puncher.yandex-team.ru/) из сетевого макроса в "Интернет". Для `_SEARCHSAND_` такая уже существует.
    
* `--node-segment` — сегмент оборудования, выбор из `default || dev`. Для разработческих ВМ предназначен сегмент `dev`, для CI/CD - сегмент `default`.
* `--volume-size` — размер аллокации, указывается число байтов, можно использовать обозначения `K, M, G, T` (8G — 8 гигабайт). **Размер должен быть не меньше, чем размер виртуального диска ВМ + размер образа ВМ + 1gb**.
   
   {% cut "Узнать размер виртуального диска можно с помощью утилиты `qemu-img`:" %}
   
   
   ```
   $ qemu-img info image.qcow2
   ```

   Результат:
   
   ```
   image: image.qcow2
   file format: qcow2
   virtual size: 8.0G (8589934592 bytes)
   disk size: 1.7G
   cluster_size: 65536
   Format specific information:
       compat: 0.10
       refcount bits: 16
   % stat -c %s image.qcow2
   1836711936
   ```
   
   Размер виртуального диска — 8Gb (virtual size в выводе команды), размер образа чуть больше 1.7Gb, следовательно, минимальный размер аллокации равен 10.8G.
   
   {% endcut %}
   
   Фактический размер виртуального диска будет равен: `размер аллокации - размер образа - 1gb`
* `--storage` — место хранения диска ВМ и остальных файлов, выбор из `hdd || ssd`. По умолчанию, для сегмента dev выбирается ssd, иначе — hdd.
* `--logins` — список логинов пользователей, являющихся владельцами ВМ, которые:
   * имеют право доступа на ВМ.
   * могут получать статусную информацию о ВМ.
   * могут управлять ВМ (рестарт, остановка и т.п.).
* `--abc` — идентификационный номер сервиса ABC для [использования квот](https://wiki.yandex-team.ru/yp/quotas/). Пользователь обязан быть в составе сервиса.
* `--use-nat64` — использование схемы [NAT64](https://wiki.yandex-team.ru/iaas/nat64/) для хождения в ipv4 ресурсы и внешний интернет. Взаимно исключает `use-white-ipv4`. Данная опция является предпочтительной, если нужен только доступ до ipv4-only ресурсов (`github.com` и т.д.).
* `--use-white-ipv4` — аллокация белого ipv4 адреса и автонастройка туннеля. Взаимно исключает `use-nat64`
   * информация про маппинг ipv4-ipv6 адресов доезжает в туннелятор через Racktables, накладные расходы составляют до 10 минут).
   * по настройке Интернета в ВМ с Windows см. [Процедура настройки доступа во внешний интернет (ipv4) в Windows](ipv4-windows.md).
* `--memory` — количество памяти для виртуальной машины (по умолчанию 8G). По факту для ВМ будет выделено на 1gb меньше (1gb используется для нужд инфраструктуры).
* `--vcpu-limit` — лимит CPU для ВМ (по умолчанию 32 ядра).
* `--vcpu-guarantee` — гарантия CPU для ВМ (по умолчанию 2 ядра).
* `-c/--vcpu` — количество ядер для ВМ.
* `-i/--image` — ссылка на образ ВМ, поддерживаются ссылки вида `rbtottent:...` и `qdm:...` (подробнее про [список образов](images-set.md)).
* `-t/--type` — ОС виртуальной машины, выбор из `linux || windows` (аргумент обязателен при указании `--image`).
* `--default-image` — можно указать один из [подготовленных образов ubuntu](images-set.md): precise, trusty, xenial, bionic, precise-dev, trusty-dev, xenial-dev, bionic-dev, xenial-gpu, bionic-gpu. Опция взаимно исключает `--image` и `--type`.
* `--extra-volume` — опции для дополнительных дисков. Формат `name=VALUE,size=SIZE[,storage=hdd|ssd][,image=TEXT]`, размер указывается аналогично параметру `volume_size`, в `image` указывается ссылка на образ диска. Можно указывать несколько раз для разных дисков, `name` должны различаться. Нельзя указывать вместе с `extra-volumes-conf`
* `--extra-volumes-conf` — файл с YAML конфигурацией дополнительных дисков ВМ. Опции совпадают с опциями из `extra-volume`. Пример файла конфигурации:

   ```yaml
   volumes:
     - name: 'disk3'
       size: '100G'
       storage: 'ssd'
     - name: 'disk4'
       size: '150G'
       storage: 'hdd'
       image: 'rbtorrent:1234567890'
   ```

Нельзя указывать вместе с `extra-volume`
* `--image-type` — тип диска `RAW` или `DELTA` (выбрано по умолчанию), [подробнее про типы](#image-type).
* `--groups` — численные идентификаторы подразделений со staff, перечисленные через пробел. Сотрудники подразделений получат доступ к ВМ в качестве владельцев.


### Как получить id группы {#create-group-id}

* Как получить group_id для подразделения стаффа

   Через [staff-api](https://staff-api.yandex-team.ru/v3/). В department.url подставить название подразделения:


   ```
   https://staff-api.yandex-team.ru/v3/groups?department.url=yandex_content_geodev_dataprod_data&_one=1&_fields=id
   ```

* Как получить group_id для сервиса ABC

   Через [staff-api](https://staff-api.yandex-team.ru/v3/). В service.id подставить численный id сервиса ABC:

   ```
   https://staff-api.yandex-team.ru/v3/groups?service.id=2900&_one=1&_fields=id
   ```
* Как получить group_id для группы ролей в сервисе ABC

   Через [staff-api](https://staff-api.yandex-team.ru/v3/). В service.id подставить численный id сервиса ABC, в role_scope — требуемую группу ролей:

   ```
   https://staff-api.yandex-team.ru/v3/groups?parent.service.id=2900&role_scope=administration&_one=1&_fields=id
   ```

{% note warning %}

Список пользователей, указанный в параметрах `--logins `, `--groups `, также используется при рассылке почтовых уведомлений, призывах в тикеты, относящихся к виртуальной машине. Учтите это при добавлении крупных подразделений!

{% endnote %}


### Примеры {#create-ex}

Примеры вызова команды `create`:

```bash
# CPU: 2 cores, RAM: 8G, Disk size 30G
$ vmctl create --pod-id my-shiny-vm --cluster VLA --network-id _SEARCHSAND_ --node-segment dev --volume-size 30G --memory 8G --vcpu 2 --default-image xenial --logins imperator volozh --groups 1 2 3 --abc 2900
# CPU: 8 cores, RAM: 32G, Disk size 30G
$ vmctl create --pod-id my-shiny-vm-huge --cluster VLA --network-id _SEARCHSAND_ --node-segment default --volume-size 30G --memory 32G --vcpu 2 --vcpu-guarantee 8000 --logins imperator volozh --groups 1 2 3 --abc 766
# CPU: 2 cores, RAM 8G, Disk size 30G, Extra disk hdd_volume, size 1024G, storage hdd
$ vmctl create --pod-id my-shiny-multistorage --cluster VLA --network-id _SEARCHSAND_ --node-segment default --volume-size 30G --memory 8G --vcpu 2 --default-image xenial --extra-volume name=hdd_volume,size=1024G,storage=hdd
# CPU: 2 cores, RAM 8G, Disk size 30G, Extra disk hdd1:1024G, storage hdd, other_data:2048G, storage ssd
$ vmctl create --pod-id my-shiny-multistorage --cluster VLA --network-id _SEARCHSAND_ --node-segment default --volume-size 30G --memory 8G --vcpu 2 --default-image xenial --extra-volume name=hdd1,size=1024G,storage=hdd --extra-volume name=other_data,size=2048G,storage=ssd
# CPU: 2 cores, RAM 8G, Disk size 30G, Extra volumes from file /home/tester/my_disks.yaml
$ vmctl create --pod-id my-shiny-multistorage --cluster VLA --network-id _SEARCHSAND_ --node-segment default --volume-size 30G --memory 8G --vcpu 2 --default-image xenial --extra-volumes-conf /home/tester/my_disks.yaml
```

После выполнения команды `create` начнется процесс выделения пода для виртуальной машины и запуска в нем vmagent. В течение этого времени команда `status` будет возвращать json вида


```
{
  "msg": "Agent was not started yet. Current status: HOOK_SEMI_FAILED", 
  "error": "Wrong state"
}
```

Среднее время создания — 5-10 минут(из за бага <https://st.yandex-team.ru/YP-475>) (может быть больше, в зависимости от размера образа ВМ). Если после пяти минут команда `status` стабильно отдает `Wrong state`, что-то идет не так и стоит обратиться за поддержкой в [telegram-rtc-support](https://t.me/joinchat/Be0kOD50fVxMoi_8hPvG6Q)

Ожидаемый вывод команды `status` после завершения:


```
$ vmctl status --pod-id my-shiny-vm --cluster VLA
state {
  type: RUNNING
}
config {
  id: "ac9c6634-3170-4eb2-9e49-c1fe38aca6b4"
  vcpu: 2
  mem: 8589934592
  disk {
    resource {
      rb_torrent: "rbtorrent:ad76739dfd7f09623fbbe395356595c41d8906d9"
      path: "/qemu-persistent/image"
      md5sum: "8eadb3a270d08b42ba0227255ef49b4f"
    }
    size: 1836711936
    delta_size: 10737418240
  }
  access_info {
    vnc_password: "43d349fd"
  }
}
```


### Как создать ВМ в персональной квоте {#create-personal}

[Подробнее](personal-quota.md) про персональные квоты.

Чтобы создать ВМ в персональной квоте, нужно:

* Выставить в параметр `abc` специальное значение `personal`
* Выставить в параметр `node-segment` значение `dev`

Пример команды `create`:

```bash
$ vmctl create --pod-id my-shiny-vm --cluster SAS --network-id _SEARCHSAND_ --node-segment dev --volume-size 20G --memory 8G --vcpu 2 --default-image xenial --abc personal
```

### Автовыбор локации при создании {#create-any}

Если выбор локации не критичен, можно передать в параметр `cluster` значение `ANY`. В этом случае локация будет подобрана для ВМ автоматически, исходя из доступных ресурсов в квоте/сегменте.

Пример:


```bash
$ vmctl create --pod-id my-shiny-vm --cluster ANY --node-segment dev --default-image xenial --vcpu 2 --abc personal
Creating my-shiny-vm in SAS
```



### Аллокация хоста целиком {#whole-host}

Для аллокации хоста целиком нужно:

1. Выбрать подходящий хост в нужном сегменте и локации:


```
$ vmctl list-free-nodes --node-segment dev --cluster SAS --limit 3
List free nodes
╒═════════╤═════════════════════════════╤═══════╤══════════════╤═══════════════╤═══════════════╤════════╕
│   Index │ Node ID                     │   CPU │       Memory │           HDD │           SSD │   IPv4 │
╞═════════╪═════════════════════════════╪═══════╪══════════════╪═══════════════╪═══════════════╪════════╡
│       1 │ sas2-3029.search.yandex.net │ 30000 │ 127041986887 │ 7887369322496 │ 1889112305664 │      0 │
├─────────┼─────────────────────────────┼───────┼──────────────┼───────────────┼───────────────┼────────┤
│       2 │ sas3-6239.search.yandex.net │ 30000 │ 127041986887 │             0 │ 1837172260864 │      1 │
├─────────┼─────────────────────────────┼───────┼──────────────┼───────────────┼───────────────┼────────┤
│       3 │ sas2-2939.search.yandex.net │ 30000 │ 127041986887 │ 7887369322496 │ 1889112305664 │      1 │
╘═════════╧═════════════════════════════╧═══════╧══════════════╧═══════════════╧═══════════════╧════════╛
$ vmctl list-free-nodes --node-segment dev --cluster SAS --limit 3 --pretty
List free nodes
╒═════════╤═════════════════════════════╤═══════╤══════════╤═══════╤═══════╤════════╕
│   Index │ Node ID                     │   CPU │   Memory │   HDD │   SSD │   IPv4 │
╞═════════╪═════════════════════════════╪═══════╪══════════╪═══════╪═══════╪════════╡
│       1 │ sas2-3029.search.yandex.net │ 30000 │      118 │  7345 │  1759 │      0 │
├─────────┼─────────────────────────────┼───────┼──────────┼───────┼───────┼────────┤
│       2 │ sas3-6239.search.yandex.net │ 30000 │      118 │     0 │  1711 │      1 │
├─────────┼─────────────────────────────┼───────┼──────────┼───────┼───────┼────────┤
│       3 │ sas2-2939.search.yandex.net │ 30000 │      118 │  7345 │  1759 │      1 │
╘═════════╧═════════════════════════════╧═══════╧══════════╧═══════╧═══════╧════════╛
```

2. Указать хост и его параметры при создании ВМ:


```
$ vmctl create --cluster SAS --pod-id my-shiny-vm --node-segment dev --default-image xenial --vcpu 30 --memory 127041986887 --volume-size 1837172260864 --node-id sas3-6239.search.yandex.net
```

При аллокации целиком, ВМ должна использовать все доступные ресурсы хоста (кроме IPv4, здесь значение показывает возможность создания туннеля на данном хосте)
Пока разрешается использовать только хосты с одним диском (HDD или SSD)



### Создание ВМ с gpu {#create-gpu}

На данный момент возможно создание ВМ с gpu только в сегменте `gpu-dev`. Для создания используется команда create

Параметры:
* `--gpu-count` — количество карт gpu
* `--gpu-model` — выбор модели gpu 
   
   {% cut "список доступных моделей" %}
   
   ```
   gpu_tesla_k40
   gpu_tesla_m40
   gpu_tesla_p40
   gpu_tesla_v100
   gpu_geforce_1080
   gpu_geforce_1080ti
   ```
   
   {% endcut %}

Пример команды:


```
$ vmctl create --cluster SAS --pod-id my-shiny-vm --node-segment gpu-dev --network-id _SEARCHSAND_ --vcpu-guarantee 8 --vcpu-limit 8 --memory 8G --volume-size 100G --gpu-count 1 --gpu-model gpu_tesla_k40 --abc 1234 --default-image xenial
```

### Указание гарантий по IO {#create-io-guarantee}

Что такое гарантии по IO и зачем они нужны — <https://clubs.at.yandex-team.ru/infra-cloud/767>

Следующие параметры отвечают за выставление гарантий по IO:
* `--io-guarantee-ssd` — суммарная гарантия для всех томов на SSD
* `--io-guarantee-hdd` — суммарная гарантия для всех томов на HDD

Значения для гарантий указываются в Bytes per second, можно использовать сокращения `M, G, T` для `Mb, Gb, Tb` соответственно. Если параметры для типа диска не указаны, никакие гарантии/лимиты не применятся для всех томов, использующих этот диск. Лимит будет равен указанной гарантии.

Механика подсчета гарантии для каждого тома: из указанного значения вычитается гарантия для инфраструктурного тома (использует тот же тип диска, что и основной том ВМ), вычисляемая по формуле 
`min(<размер суммарной гарантии> / 3, 10Mbs)`
полученное значение делится на количество томов с соответствующим типом диска, результат будет указан в качестве гарантии для каждого тома.

Примеры:
* `$ vmctl create --cluster SAS --pod-id my-shiny-vm --node-segment dev --default-image xenial --storage ssd --io-guarantee-ssd 30M `
   Распределение гарантий:
     * инфраструктурный том на ssd: `10Mbs`
     * основной том на ssd: `20Mbs`
* `$ vmctl create --cluster SAS --pod-id my-shiny-vm --node-segment dev --default-image xenial --storage ssd --io-guarantee-ssd 30M --extra-volume name=data,size=100G,storage=ssd`
   Распределение гарантий:
     * инфраструктурный том на ssd: `10Mbs`
     * основной том на ssd: `10Mbs`
     * том data на ssd: `10Mbs`
* `$ vmctl create --cluster SAS --pod-id my-shiny-vm --node-segment dev --default-image xenial --storage ssd --io-guarantee-ssd 30M --extra-volume name=data,size=100G,storage=hdd`
   Распределение гарантий:
     * инфраструктурный том на ssd: `10Mbs`
     * основной том на ssd: `20Mbs`
     * том data на hdd: `0Mbs`
* `$ vmctl create --cluster SAS --pod-id my-shiny-vm --node-segment dev --default-image xenial --storage hdd --io-guarantee-ssd 30M --extra-volume name=data,size=100G,storage-ssd`
   Распределение гарантий:
     * инфраструктурный том на hdd: `0Mbs`
     * основной том на hdd: `0Mbs`
     * том data на ssd: `30Mbs`


## Про тип диска (image-type) {#image-type}


### Какой выбрать? {#choose-image-type}

Тип **DELTA** подразумевает запись всех изменений в новый файл, отличный от используемого при создании образа (подробнее про [Redirect-on-Wrtie](http://www.ibm.com/developerworks/tivoli/library/t-snaptsm1/index.html)).

В этом случае имеем:
* быстрый откат всех изменений, достаточно удалить файл диска (current.qcow2) и создать новый (команда `vmctl revert`)
* возможность использовать механизм снепшотов. Нужно создать новый диск на основе старого, далее можно будет откатиться либо на старый диск, либо на исходный. При желании можно сделать дерево снепшотов, с возможностью использования любого из них.

   {% note alert %}

   Вышеизложенные операции над снепшотами не поддержаны в vmctl. Выполнять их нужно с помощью утилиты qemu-img внутри контейнера с виртуальной машиной.

   {% endnote %}

Главный недостаток данного типа — накладные расходы. Каждому снепшоту нужно свободное место, равное по размеру виртуальному диску виртуальной машины.
При этом размер занимаемого снепшотом места может быть гораздо больше размера данных внутри, в пике он достигает размера виртуального диска.

**Пример**:

Имеем диск с виртуальной машиной, совокупный размер данных на ней 5gb, размер виртуального диска 100gb. Создаем на его основе вируальную машину в QYP, под нее нужно будет выделить 5gb + 100gb (+1gb на инфраструктурные нужды) дискового пространства. Если планируется использование еще 3 снепшотов помимо основного диска, нужно выделить 5 + 100 + 3 * 100 + 1 = 406gb. 
В условиях квотирования диска в облаке такое использование ресурсов может показаться нецелесообразным. Кроме того, изменение размера диска, выделенного под существующую виртуальную машину невозможно, что ограничивает возможности по созданию новых снепшотов.

При использовании типа **RAW** данные пишутся прямо в образ, выбранный при создании виртуальной машины. Получаем большую по сравнению с DELTA производительность дисковой подсистемы за счет отсутствия дополнительных действий в моменты выполнения операций чтения и записи. 
Так как используется один файл диска, для него нужно выделить место, равное размеру виртуального диска + расходы на инфраструктурные нужды.
Быстрый откат и снепшоты для RAW недоступны — вместо них придется использовать периодические бэкапы и хранить оригинальный образ для отката всех изменений.

**Итого**: если планируется активное использование снепшотов/отката стоит выбрать тип DELTA, при этом нужно заранее посчитать, сколько выделить дискового пространства под ВМ. Иначе выбирать RAW.


### Как мигрировать {#migrate-image-type}

Возможно смигрировать существующую ВМ с типа DELTA на RAW. Для этого нужно:
1. Сделать бэкап. Бэкап нужен для сохранения данных, если данные не нужны, можно взять оригинальный образ, с которым создавалась ВМ.
1. Полученный на предыдущем шаге образ использовать в комманде vmctl config, указать `image-type=RAW`

Миграция с RAW на DELTA пока недоступна из-за необходимости увеличить размер диска.


## Изменение параметров ВМ {#update}

Операция изменения позволяет поменять почти все параметры ВМ, указанные при создании (на данный момент отсутствует возможность менять размер и тип диска).

Изменение следующих параметров не приводит к перезагрузке ВМ:
* `abc` — указывается численный идентификатор abc группы
* `logins` — указывается новый список владельцев ВМ
* `groups` — указывается новый список групп, имеющих доступ к ВМ в формате [staff_group_id](#create-group-id)
* `clear-groups` — флаг для очистки списка групп, имеющих доступ к ВМ
* `io-guarantee-ssd` — суммарная гарантия по IO для всех томов на SSD
* `io-guarantee-hdd` — суммарная гарантия по IO для всех томов на HDD

Изменение следующих параметров ведет к перезагрузке ВМ:
* `network-id` — сетевой макрос
* `use-nat64` — использование схемы [NAT64](https://wiki.yandex-team.ru/iaas/nat64/) для хождения в ipv4 ресурсы и внешний интернет.
* `gpu-count` — количество используемых карт gpu
* `gpu-model` — модель используемых карт gpu

Изменение следующих параметров ведет к перезагрузке ВМ. Изменения приводят к пересозданию образа диска и потере пользовательских данных для `vmagent < 0.23`, поэтому при применении этих изменений vmctl предложит сначала обновить vmagent до последней версии:
* `--memory` — количество памяти для виртуальной машины (по умолчанию 8G). По факту для ВМ будет выделено на 1gb меньше (1gb используется для нужд инфраструктуры).
* `vcpu-limit` — лимит CPU для ВМ (по умолчанию 32 ядра)
* `vcpu-guarantee` — гарантия CPU для ВМ (по умолчанию 2 ядра) Для сегмента оборудования `dev` невозможно указать гарантию больше, чем 8 ядер
* `vcpu` — количество ядер для ВМ

Изменения будут применены, если на хосте, на котором находится ВМ остались свободные ресурсы. В противном случае будет выдано сообщение вида:


```
Error: Method /commit_transaction replied with error: Cannot satisfy resource requests for pod "my-shiny-vm" at node "vla2-9589.search.yandex.net": "cpu" capacity limit exceeded at node: allocated 76195, requested 8000, total 78422: Cannot satisfy "cpu" request
```

Изменение следующих параметров приводит к пересозданию образа диска и потере пользовательских данных:
* `image` — ссылка на образ ВМ, поддерживаются только ссылки вида `rbtottent:...` (подробнее про [список образов](images-set.md))
* `type` — ОС виртуальной машины, выбор из `linux || windows` (аргумент обязателен при указании `--image`)
* `default-image` — можно указать один из [подготовленных образов ubuntu](images-set.md): precise, trusty, xenial, bionic, precise-dev, trusty-dev, xenial-dev, bionic-dev. Опция взаимно исключает `--image` и `--type`
* `image-type` — тип диска `RAW` или `DELTA` (выбрано по умолчанию), [подробнее про типы](#image-type).
* `node-id` — хост для аллокации целиком
* `remove-node-id` — флаг для отмены хостовой аллокации, ВМ будет перемещена с хоста

Изменение следующих параметров приводит к перезагрузке ВМ и пересозданию выбранных дисков ВМ:
* `--extra-volume` — опции для дополнительных дисков. Формат `name=VALUE,size=SIZE[,storage=hdd|ssd][,image=TEXT]`, размер указывается аналогично параметру `volume_size`, в `image` указывается ссылка на образ диска. Можно указывать несколько раз для разных дисков, `name` должны различаться. Нельзя указывать вместе с `extra-volumes-conf`
* `--remove-volumes` — список имен дополнительных дисков, которые требуется удалить из ВМ. Нельзя указывать вместе с `extra-volumes-conf`
* `--extra-volumes-conf` — файл с YAML конфигурацией дополнительных дисков ВМ. Опции совпадают с опциями из `extra-volume`. Пример файла конфигурации:


```yaml
volumes:
  - name: 'disk3'
    size: '100G'
    storage: 'ssd'
  - name: 'disk4'
    size: '150G'
    storage: 'hdd'
    image: 'rbtorrent:1234567890'
```

Нельзя указывать вместе с `extra-volume` или `remove-volumes`

Примеры:


```bash
#перенести вм в сервис с квотой
$ vmctl update --cluster VLA --pod-id my-shiny-vm --abc 2900
#обновить список пользователей ВМ
$ vmctl update --cluster VLA --pod-id my-shiny-vm --logins volozh imperator --groups 1 2 3
#очистить список групп 
$ vmctl update --cluster VLA --pod-id my-shiny-vm --clear-groups
#увеличить доступное количество cpu
$ vmctl update --cluster VLA --pod-id my-shiny-vm --vcpu-guarantee 8 --vcpu-limit 32 --vcpu 32
#увеличить количество памяти
$ vmctl update --cluster VLA --pod-id my-shiny-vm --memory 10G
#изменить образ на дефолтный bionic
$ vmctl update --cluster VLA --pod-id my-shiny-vm --default-image bionic
#удалить дополнительный диск other_data
$ vmctl update --cluster VLA --pod-id my-shiny-vm --remove-volumes other_data
#изменить конфигурацию дополнительных дисков в соответствии с файлом /home/tester/my-extra-disks.yaml
$ vmctl update --cluster VLA --pod-id my-shiny-vm --extra-volumes-conf /home/tester/my-extra-disks.yaml
#добавить дополнительный диск 
$ vmctl update --cluster VLA --pod-id my-shiny-vm --extra-volume name=other_data,size=1024G,storage=hdd
```



### Обновление версии vmagent в контейнере {#update-vmagent}

С помощью команды `update-vmagent` можно обновить версию vmagent в контейнере до последней. Посмотреть используемую версию можно с помощью команды `list`.
При обновлении vmagent ВМ останавливается автоматически. Рекомендуется самостоятельно остановить виртуальную машину посредством команды `shutdown` во избежание повреждения системы.
Примеры:


```bash
$ vmctl list --fields name vmagent_version
╒═════════╤══════════════════════╤═══════════╕
│   Index │ Name                 │ Vmagent   │
╞═════════╪══════════════════════╪═══════════╡
│       1 │ test-old-vmagent     │ v0.11     │
├─────────┼──────────────────────┼───────────┤
│       2 │ test-just-vmagent    │ v0.14     │
├─────────┼──────────────────────┼───────────┤
│       3 │ test-new-vmagent     │ v0.15     │
╘═════════╧══════════════════════╧═══════════╛
$ vmctl update-vmagent --cluster VLA --pod-id test-old-vmagent
VM will be stopped during this action, all unsaved data will be lost.
Continue? [Y/N]:y
$ vmctl list --fields name vmagent_version
╒═════════╤══════════════════════╤═══════════╕
│   Index │ Name                 │ Vmagent   │
╞═════════╪══════════════════════╪═══════════╡
│       1 │ test-old-vmagent     │ v0.15     │
├─────────┼──────────────────────┼───────────┤
│       2 │ test-just-vmagent    │ v0.14     │
├─────────┼──────────────────────┼───────────┤
│       3 │ test-new-vmagent     │ v0.15     │
╘═════════╧══════════════════════╧═══════════╛
```



## Список созданных ВМ {#list}

Команда `vmctl list` выводит таблицу с созданными ВМ и их параметрами. ВМ попадает в таблицу, если был заказ на ее аллокацию (командами create/allocate), независимо от успешности выполнения заказа.

Список параметров:
* `--mode` — тип источника yp/gencfg, по умолчанию yp
* `--cluster` — список локаций ВМ для фильтрации, по умолчанию показывет все локации
* `--login` — фильтровать по имени пользователя, добавленного в logins/groups ВМ, по умолчанию используется имя пользователя, вызывающего команду vmctl
* `--login-all` — не фильтровать по имени пользователя
* `--node-segment` — список сегментов оборудования для фильтрации, по умолчанию показывает все сегменты
* `--fields` — показывать только поля из передаваемого списка, по умолчанию не используется, показываются все поля (`name, location, segment, cpu, ram, disk, logins, groups, abc`)
* `--abc` — фильтр по abc, в квоте которого была создана ВМ, можно указывать несколько через пробел, формат `"abc:service:<числовой id сервиса>"`

Примеры вызова:
* Посмотреть ВМ пользователя volozh в кластере MAN, сегментах dev и default, показать только поля name, cpu, ram, disk
    `$ vmctl list --cluster MAN --login volozh --node-segment dev default --fields name cpu ram disk`
* Посмотреть все ВМ всех пользователей, показывать все поля
    `$ vmctl list --login-all`
* Посмотреть все ВМ в квоте сервиса
    `$ vmctl list --login-all --abc "abc:service:1234"`



## Просмотр потребления ресурсов в доступных квотах {#list-accounts}

Команда `list-accounts` выводит размеры потребляемых ресурсов и лимиты по этим ресурсам в квотах, доступных пользователю.
В первой таблице (Group Quotas) указано потребление для сервисных квот, во второй (Personal Quotas) указано потребление в персональной квоте и нормализованное потребление по всем сервисным квотам пользователя ([подробнее](personal-quota.md#workflow))

Список параметров
* `--cluster` — список локаций ВМ для фильтрации, по умолчанию показывет все локации
* `--segment` — список сегментов оборудования для фильтрации, по умолчанию показывает все сегменты
* `--detailed` — опция включает отображение в таблице всех виртуальных машин для каждой квоты. Для персональной квоты отображаются только вм, созданные пользователем



{% cut "Примеры вызова:" %}

```
$ vmctl list-accounts --detailed
Group Quotas
╒═════════╤══════════════════╤════════════╤═══════════╤═════════════╤══════════════════╤═════════════╤═════════════╤═════════════╤═════════════╤═════════════╤═════════════╤══════════════╤══════════════╕
│   Index │ Name             │ Location   │ Segment   │   CPU Usage │        CPU Limit │ Mem Usage   │ Mem Limit   │ HDD Usage   │ HDD Limit   │ SSD Usage   │ SSD Limit   │   IPv4 Usage │   IPv4 Limit │
╞═════════╪══════════════════╪════════════╪═══════════╪═════════════╪══════════════════╪═════════════╪═════════════╪═════════════╪═════════════╪═════════════╪═════════════╪══════════════╪══════════════╡
│       1 │ abc:service:1979 │ MAN        │ default   │       15000 │            20000 │ 29G         │ 90G         │ 235G        │ 5120G       │ 0G          │ 0G          │            0 │            0 │
├─────────┼──────────────────┼────────────┼───────────┼─────────────┼──────────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼──────────────┼──────────────┤
│       2 │ abc:service:1979 │ SAS        │ default   │       10100 │            20000 │ 18G         │ 90G         │ 298G        │ 5120G       │ 0G          │ 0G          │            0 │            0 │
├─────────┼──────────────────┼────────────┼───────────┼─────────────┼──────────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼──────────────┼──────────────┤
│       3 │ abc:service:2900 │ SAS        │ dev       │        4000 │             8000 │ 16G         │ 32G         │ 26G         │ 1024G       │ 46G         │ 1024G       │            0 │            0 │
├─────────┼──────────────────┼────────────┼───────────┼─────────────┼──────────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼──────────────┼──────────────┤
│         │ tester-test-vm   │ SAS        │           │        2000 │                  │ 8G          │             │ 20G         │             │ 6G          │             │            0 │              │
├─────────┼──────────────────┼────────────┼───────────┼─────────────┼──────────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼──────────────┼──────────────┤
│         │ shiny-vm         │ SAS        │           │        2000 │                  │ 8G          │             │ 6G          │             │ 40G         │             │            0 │              │
╘═════════╧══════════════════╧════════════╧═══════════╧═════════════╧══════════════════╧═════════════╧═════════════╧═════════════╧═════════════╧═════════════╧═════════════╧══════════════╧══════════════╛
Personal Quotas
╒═════════╤════════════════╤════════════╤═══════════╤═════════════╤═════════════╤═════════════╤═════════════╤═════════════╤═════════════╤═════════════╤═════════════╤══════════════╤══════════════╕
│   Index │ Name           │ Location   │ Segment   │   CPU Usage │   CPU Limit │ Mem Usage   │ Mem Limit   │ HDD Usage   │ HDD Limit   │ SSD Usage   │ SSD Limit   │   IPv4 Usage │   IPv4 Limit │
╞═════════╪════════════════╪════════════╪═══════════╪═════════════╪═════════════╪═════════════╪═════════════╪═════════════╪═════════════╪═════════════╪═════════════╪══════════════╪══════════════╡
│       1 │ PERSONAL       │            │ dev       │        4000 │        8000 │ 16G         │ 50G         │ 0G          │ 0G          │ 120G        │ 300G        │            0 │            0 │
├─────────┼────────────────┼────────────┼───────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼──────────────┼──────────────┤
│         │ test-personal2 │ SAS        │           │        2000 │             │ 8G          │             │ 0G          │             │ 20G         │             │            0 │              │
├─────────┼────────────────┼────────────┼───────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼──────────────┼──────────────┤
│         │ test-personal  │ SAS        │           │        2000 │             │ 8G          │             │ 0G          │             │ 100G        │             │            0 │              │
├─────────┼────────────────┼────────────┼───────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼─────────────┼──────────────┼──────────────┤
│       2 │ Group Cons.    │            │ dev       │        2000 │        8000 │ 15G         │ 50G         │ 83G         │ 0G          │ 83G         │ 300G        │            1 │            0 │
╘═════════╧════════════════╧════════════╧═══════════╧═════════════╧═════════════╧═════════════╧═════════════╧═════════════╧═════════════╧═════════════╧═════════════╧══════════════╧══════════════╛
```

{% endcut %}



## Другие команды {#other}


### Аллокация подов для ВМ {#allocate}

Список параметров:
* `--network-id` — сетевой макрос из [Racktables](https://racktables.yandex-team.ru/index.php?page=services&tab=projects) для доступа к ВМ по сети.
    
    Если у вашего подразделения уже есть свой сетевой макрос, то имеет смысл использовать его — тогда дырки этого макроса будут работать и с вашей ВМ.
    
    Если вы не в курсе про сетевые макросы, то рекомендуется просто указывать макрос `_SEARCHSAND_` (<https://puncher.yandex-team.ru/?destination=_SEARCHSAND_&rules=exclude_rejected&values=all&sort=destination>).
    
    Если вы понимаете, что происходит и какая модель сетевого доступа вам нужна, то можете создать свой сетевой макрос [здесь](https://wiki.yandex-team.ru/NOC/newnetwork/hbf/projectid/project-id-allocation/#opisanieformy), прокрутить нужные дырки и использовать его для ВМ.
    
* `--node-segment` — сегмент оборудования, выбор из `default || dev`. Для разработческих ВМ рекомендуется выбирать сегмент dev.
* `--volume-size` — размер аллокации, указывается число байтов, можно использовать обозначения `K, M, G, T` (8G — 8 гигабайт). **Размер должен быть не меньше, чем размер виртуального диска ВМ + размер образа ВМ**.
   
   {% cut "Узнать размер виртуального диска можно с помощью утилиты `qemu-img`:" %}
   
   ```bash
   $ qemu-img info image.qcow2
   image: image.qcow2
   file format: qcow2
   virtual size: 8.0G (8589934592 bytes)
   disk size: 1.7G
   cluster_size: 65536
   Format specific information:
       compat: 0.10
       refcount bits: 16
   % stat -c %s image.qcow2
   1836711936
   ```
   
   Размер виртуального диска — 8Gb (virtual size в выводе команды), размер образа чуть больше 1.7Gb, следовательно, минимальный размер аллокации равен 9.8G.

   {% endcut %}
   
* `--storage` — место хранения диска ВМ и остальных файлов, выбор из `hdd || ssd`. По умолчанию, для сегмента dev выбирается ssd, иначе — hdd.
* `--logins` — список логинов пользователей, являющихся владельцами ВМ, которые:
   * имеют право доступа на ВМ;
   * могут получать статусную информацию о ВМ;
   * могут управлять ВМ (рестарт, остановка и т.п.);
* `--abc` — идентификационный номер сервиса ABC для [использования квот](https://wiki.yandex-team.ru/yp/quotas/). Пользователь обязан быть в составе сервиса

Следующие параметры необязательны, используются значения по умолчанию:
* `--use-nat64` — использование схемы [NAT64](https://wiki.yandex-team.ru/iaas/nat64/) для хождения в ipv4 ресурсы и внешний интернет. Взаимно исключает `use-white-ipv4`. Данная опция является предпочтительной, если нужен только доступ до ipv4-only ресурсов (`github.com` и т.д.).
* `--use-white-ipv4` — аллокация белого ipv4 адреса и автонастройка туннеля. Взаимно исключает `use-nat64`
   * информация про маппинг ipv4-ipv6 адресов доезжает в туннелятор через Racktables, накладные расходы составляют до 10 минут);
   * по настройке Интернета в ВМ с Windows см. [Процедура настройки доступа во внешний интернет (ipv4) в Windows](ipv4-windows.md)
* `--memory` — количество памяти для виртуальной машины (по умолчанию 8G). **Количество памяти для аллокации ВМ должно быть больше количества желаемой памяти для ВМ на 5-10% или на 1Gb**.
* `--vcpu-limit` — лимит CPU для ВМ (по умолчанию 32000 = 32 ядра)
* `--vcpu-guarantee` — гарантия CPU для ВМ (по умолчанию 2000 = 2 ядра) Для сегмента оборудования `dev` невозможно указать гарантию больше, чем 2 ядра
* `--groups` — численные идентификаторы подразделений со staff, перечисленные через пробел. Сотрудники подразделений получат доступ к ВМ в качестве владельцев.
     
   
   {% cut "Как получить group_id для подразделения стаффа" %}
   
   Через [staff-api](https://staff-api.yandex-team.ru/v3/). В department.url подставить название подразделения:
   
   ```
   https://staff-api.yandex-team.ru/v3/groups?department.url=yandex_content_geodev_dataprod_data&_one=1&_fields=id
   ```
   
   {% endcut %}
   
     
   {% cut "Как получить group_id для сервиса ABC" %}
   
   Через [staff-api](https://staff-api.yandex-team.ru/v3/). В service.id подставить численный id сервиса ABC:
   
   ```
   https://staff-api.yandex-team.ru/v3/groups?service.id=2900&_one=1&_fields=id
   ```
   
   {% endcut %}

Примеры вызова команды `allocate`:


```
# CPU: 2 cores, RAM: 8G, Disk size 30G
$ vmctl allocate --pod-id my-shiny-vm --cluster MAN --network-id _GENCFG_SEARCHPRODNETS_ROOT_ --node-segment dev --volume-size 30G --memory 8G --logins imperator volozh --groups 1 2 3 --abc 2900
# CPU: 8 cores, RAM: 32G, Disk size 30G
$ vmctl allocate --pod-id my-shiny-vm-huge --cluster MAN --network-id _GENCFG_SEARCHPRODNETS_ROOT_ --node-segment default --volume-size 30G --memory 32G --vcpu-guarantee 8000 --logins imperator volozh --groups 1 2 3 --abc 766
```

После выполнения команды `allocate` начнется процесс выделения пода для виртуальной машины и запуска в нем vmagent. В течение этого времени команда `status` будет возвращать json вида


```
{
  "msg": "Agent was not started yet. Current status: HOOK_SEMI_FAILED", 
  "error": "Wrong state"
}
```

Среднее время аллокации — не более 5 минут. Если после пяти минут команда `status` стабильно отдает `Wrong state`, что-то идет не так и стоит обратиться за поддержкой в [telegram-rtc-support](https://t.me/joinchat/Be0kOD50fVxMoi_8hPvG6Q)

Ожидаемый вывод команды `status` после завершения аллокации:


```bash
$ vmctl status --pod-id my-shiny-vm --cluster MAN
{
    "state": {},
    "config": {}
}
```



### Конфигурация {#config}

Для конфигурации ВМ нужно выполнить команду `vmctl config`. Это действие можно выполнять как на пустой аллокации, так и на уже сконфигурированной или запущенной, **в этом случае диски и ресурсы удалятся**, старая конфигурация заменится на новую.

Список параметров:
* `-c/--vcpu` — количество ядер для ВМ.
    
    {% note alert %}

    Количество указывается в штуках, в отличие от команды `allocate`.
    
    {% endnote %}

* `-m/--mem` — количество памяти для ВМ, должно быть меньше, чем количество памяти для аллокации (см раздел Аллокация подов)
* `-s/--disk` — размер виртуального диска ВМ
* `-i/--image` — ссылка на образ ВМ, поддерживаются только ссылки вида `rbtottent:...` (подробнее про [список образов](images-set.md))
* `-t/--type` — ОС виртуальной машины, выбор из `linux || windows`
* `--autorun` — при указании опции ВМ автоматически стартует, как только статус == `CONFIGURED || CRASHED` (статус `STOPPED` означает ручную остановку, автозапуска не будет). В этом случае ВМ будет пытаться запуститься, если была аварийно остановлена, например из-за рестарта хоста. По умолчанию опция выключена.
* `--default-image` — можно указать один из [подготовленных образов ubuntu](images-set.md): precise, trusty, xenial, precise-dev, trusty-dev, xenial-dev. Опция взаимно исключает `--image` и `--type`
* `--image-type` — тип диска `RAW` или `DELTA` (выбрано по умолчанию), [подробнее про типы](#image-type).

Примеры вызова:


```bash
# сконфигурировать вм с параметрами: 4 ядра, 4Гб оперативной памяти, 20Гб размер виртуального диска
$ vmctl config --cluster MAN --pod-id my-shiny-vm -c 4 -m 4G -s 20G -t linux -i rbtorrent:12345
# взять преднастроенный образ ubuntu xenial
$ vmctl config --cluster MAN --pod-id my-shiny-vm -c 4 -m 4G -s 20G --default-image xenial
```

После вызова ВМ перейдет сначала в состояние `BUSY` (удаляется старая конфигурация при наличии), затем в `PREPARING` (скачивается образ). 
Потом она перейдет либо в `CONFIGURED` — ВМ в начальном состоянии, можно запускать, либо в `INVALID` — ошибка при скачке, требуется повторный запуск `vmctl config`



### Запуск {#run}

Для запуска используется команда `vmctl start`. После выполнения ВМ переходит в состояние `RUNNING`.


{% cut "Пример запуска ВМ" %}

```
$ vmctl start --cluster MAN --pod-id my-shiny-vm
$ vmctl status --cluster MAN --pod-id my-shiny-vm
state {
  type: RUNNING
}
config {
  id: "ac9c6634-3170-4eb2-9e49-c1fe38aca6b4"
  vcpu: 2
  mem: 8589934592
  disk {
    resource {
      rb_torrent: "rbtorrent:ad76739dfd7f09623fbbe395356595c41d8906d9"
      path: "/qemu-persistent/image"
      md5sum: "8eadb3a270d08b42ba0227255ef49b4f"
    }
    size: 1836711936
    delta_size: 10737418240
  }
  access_info {
    vnc_password: "43d349fd"
  }
}
```

{% endcut %}



### Создание бэкапа {#backup}

Выполняется командой `vmctl backup`. Перед бэкапом необходимо провести апдейт vmagent, если вы используете старую версию vmagent, вам будет предложено подтвердить его обновление


```
$ vmctl backup --cluster VLA --pod-id my-shiny-vm
VM will be stopped during this action, all unsaved data will be lost.
Continue? [Y/N]:y
Used vmagent version does not support this operation.
Would you like to update vmagent to latest version? [Y/N]:
```

Все файлы всех дисков ВМ загружаются в MDS. Генерируется специальный ключ вида `qdm:xxxxx`, который можно использовать при создании новой ВМ в QYP.
Следить за прогрессом выполнения можно при помощи команды list-backup. Новый бэкап будет в статусе `IN_PROGRESS`, уже завершенные — в статусе `COMPLETED`:


```
$ vmctl list-backup --cluster SAS --pod-id my-shiny-vm
╒═════════╤══════════════════════════════════════════════════════════════════╤═══════════╤═════════════════════╤═════════════╤══════════════════════════════════════════════════════════════════════╕
│   Index │ Id                                                               │ Task id   │ Date                │ Status      │ Url                                                                  │
╞═════════╪══════════════════════════════════════════════════════════════════╪═══════════╪═════════════════════╪═════════════╪══════════════════════════════════════════════════════════════════════╡
│       1 │ ccdb859e2f7687ba1fc36b7b19d7983e3923fc50ed69b25f4bea00f12345eccd │           │ 2020-09-14 08:11:26 │ COMPLETED   │ qdm:ccdb859e2f7687ba1fc36b7b19d7983e3923fc50ed69b25f4bea00f12345eccd │
├─────────┼──────────────────────────────────────────────────────────────────┼───────────┼─────────────────────┼─────────────┼──────────────────────────────────────────────────────────────────────┤
│       2 │                                                                  │           │                     │ IN_PROGRESS │                                                                      │
╘═════════╧══════════════════════════════════════════════════════════════════╧═══════════╧═════════════════════╧═════════════╧══════════════════════════════════════════════════════════════════════╛
```

Допустимо хранение трех копий ВМ, при превышении лимита старые копии будут удаляться. Время хранения бэкапа в MDS составляет 1 год, после чего бэкап будет удален.



### Получение rbtorrent-ссылки на образ ВМ {#share-image}

*Требуется vmagent версии 0.34*

Команда выполняет `sky share` для файлов основного тома ВМ. Перед началом выполнения ВМ будет остановлена. 
После вычисления контрольной суммы для файлов тома (занимает некоторое время, в зависимости от размера тома) ссылки появятся в статусе ВМ, в разделе state.sharedImage (см пример).

Ссылки будут доступны пока ВМ находится в выключенном состоянии. Файлы будут скачиваться из контейнера с ВМ, при уничтожении/изменении образа ссылки перестанут быть валидными. Для сохранения файлов рекомендуется скопировать их в другое место, например в Sandbox, используя задачу `REMOTE_COPY_RESOURCE` (create task в sandbox, выбрать `REMOTE_COPY_RESOURCE` из выпадающего списка, дальше заполнить поля, resource type можно поставить в OTHER_RESOUCE)

```
$ vmctl share-image --cluster SAS --pod-id my-shiny-vm
$ vmctl status --cluster SAS --pod-id my-shiny-vm
{
    "vmagentVersion": "0.34",
    "state": {
        "info": "",
        "targetType": "STOPPED",
        "rescue": false,
        "generation": 2,
        "type": "STOPPED",
        "netAlive": false,
        "linkAlive": false,
        "backup": {
            "imageUrl": "",
            "sandboxTaskUrl": "",
            "deltaUrl": ""
        },
        "sharedImage": {
            "imageUrl": "rbtorrent:913ad2047a052d93d908370db6b7d0e9369cdcde",
            "creationTime": "2020-06-08T16:49:05.325811Z",
            "deltaUrl": ""
        },
        "issues": []
    },
    ...
```

Примечания:
* Время создания ссылки указано в UTC
* Для ВМ c `image_type == RAW` генерируется только `imageUrl`, для `image_type == DELTA` генерируются `imageUrl` и `deltaUrl`
* Для получения из двух ссылок (image и delta) готового образа QYP можно воспользоваться sandbox-задачей `MERGE_QEMU_IMAGE`. При этом новую ВМ нужно будет создать с бОльшим размером [QEMUKVM-345](https://st.yandex-team.ru/QEMUKVM-345)



## Доступ к ВМ {#access-vm}

После запуска можно получить доступ к ВМ, используя адрес `<vm_id>.<cluster>.yp-c.yandex.net`

Для этого должны быть заказаны дырки к сетевому макросу, указанному при аллокации с нужными портами.

## Мониторинг ВМ {#monitoring}

Для того, чтобы вывести в [Golovan](http://yasm.yandex-team.ru/) сигналы c контейнера с Вашей ВМ необходимо в качестве тегов указать: `itype=qemuvm`, `hosts=ASEARCH`, `ctype=prod`, `prj=<id виртуальной машины>`.

В [Golovan](http://yasm.yandex-team.ru/) доступны все метрики с porto-контейнера, в рамках которого разворачивается ВМ, а также набор сигналов с unistat-ручки, характеризующий состояние ВМ (busy, configured, running, crashed, empty, invalid, preparing, stopped, link_alive, net_alive).

Мониторинг работает для ВМ, созданных в QYP после 18:00 22.06.2018.



## Режим восстановления {#rescue}

Режим, в котором можно починить файловую систему или незагружаемую конфигурацию. 

Чтобы войти в режим восстановления, нужно:
1. Отключить ВМ (`shutdown, poweroff`) Виртуальная машина должна быть в состоянии `STOPPED/CRASHED`
1. Вызвать `vmctl rescue ...`. Действие аналогично команде `start`, но запускается rescue-shell
1. Дождаться статуса `RUNNING` и зайти в ВМ через vnc
1. После выполнения действий, отключить ВМ (`poweroff`)
1. Заново включить ВМ `start`


### Примеры использования (linux-vm) {#rescue-ex}

{% cut "fsck" %}

```
# mkdir /sys; mount -t sysfs sysfs /sys
# cat /sys/block/vda/dev
# mknod /dev/vda b 253 0 # последние два аргумента — результат выполнения предыдущей команды
# fsck.ext4 -y -f /dev/vda
```

Если при запуске fsck вы видете ошибку с текстом `The superblock could not be read` это означает, что на /dev/vda нет файловой системы и присутствует отдельная партиция на диске. Проверить это возможно командой `ls /sys/block/vda/vda1`

Далее вам необходимо создать устройство /dev/vda1 так же как и в первом примере:


```
# cat /sys/block/vda/vda1/dev
# mknod /dev/vda1 b 253 1 # последние два аргумента — результат выполнения предыдущей команды
# fsck.ext4 -y -f /dev/vda1
```

{% endcut %}

{% cut "Редактирование extlinux.conf" %}

```
# mkdir /sys; mount -t sysfs sysfs /sys
# cat /sys/block/vda/dev
# mknod /dev/vda b 253 0 # последние два аргумента — результат выполнения предыдущей команды
# mkdir /mnt
# mount -t ext4 /dev/vda /mnt
# vim /mnt/extlinux.conf
# umount /mnt
```

{% endcut %}


{% cut "Установка пароля, чтобы попасть внутрь ВМ по паролю из VNC" %}

```
# mkdir /sys; mount -t sysfs sysfs /sys
# cat /sys/block/vda/dev
# mknod /dev/vda b 253 0 # последние два аргумента — результат выполнения предыдущей команды
# mkdir /mnt
# mount -t ext4 /dev/vda /mnt
# chroot /mnt
# passwd -u root 
# passwd root
# exit
# umount /mnt
```

{% endcut %}


### Восстановление Windows {#rescue-win}

В rescue-shell также включен набор утилит из пакета `ntfsprogs`, можно попробовать
смонтировать NTFS и что-либо поправить.

## Возможные проблемы и их решения {#issues}

* [{#T}](troubleshooting.md)
