# IO-лимиты в QYP

## Цель {#aim}

Чтобы корректно функционировать, большинству ВМ и сервисов нужно иметь гарантию на скорость выполнения дисковых операций. Для того, чтобы обеспечить эту гарантию, в YP проходит процесс внедрения гарантий и лимитов на чтение с диска. Подробно об этом процессе и о том, как устроены IO-лимиты, можно почитать в соответствующем посте: <https://clubs.at.yandex-team.ru/infra-cloud/767>

## Принцип работы лимитов {#limits}

IO лимит для qyp ВМ ограничивает чтение и запись.

Пользователь на текущий момент может выставить на ВМ гарантию в мегабайтах в секунду. *Гарантия* используется при планировании пода, на самой ноде никак не отражена. Наоборот, *лимит* учитывается на ноде и никак не влияет на размещение пода. Чтобы указать гарантию требуется соответствующая квота в ABC / Dispenser. Лимит будет выставлен автоматом в зависимости от гарантии чтобы избежать злоупотребления.

У IO есть два измерения: `bandwidth` и `iops`. Лимит ограничивает оба измерения:

|       | bandwidth | iops |
| ----- | --------- | ---- |
| read  | ✓        | ✓   |
| write | ✓        | ✓   |


Кол-во iops в секунду зависит от указанного bandwidth по формуле:

$\frac {bandwidth * sr\_bandwidth\_factor}{rr\_iops\_divisor}$

Значения коэффициентов для разных типов дисков взяты из [arcadia](https://a.yandex-team.ru/arc/trunk/arcadia/infra/yp_export/models/disks.json):

| storage_class | rr_iops_divisor | sr_bandwidth_factor | iops per MiB/s |
| ------------- | --------------- | ------------------- | -------------- |
| hdd           | 131072          | 1                   | 8              |
| ssd           | 8192            | 1                   | 128            |
| nvme          | 4096            | 1                   | 256            |

В storage_class для массивов пропускная способность дисков суммируется.

Потребление IO для своей ВМ можно посмотреть зайдя на <https://qyp.yandex-team.ru>, перейдя к нужной вм и в разделе **VM STATS** на виджет **Disk operations**.

Гарантии для вм в default подобраны как **95-ый перцентиль** потребления сервисом bandwidth на ssd и hdd, bandwidth для ssd оценивается по метрике `portoinst-io_read_bytes_/ssd_tmmv`, bandwidth для hdd считается по метрике `portoinst-io_read_bytes_/place_tmmv`.

Перед взятием квантили нули удаляются из серии, квантиль считается по данным за две недели. Гарантии в dev сегменте считаются относительно реальных аллокаций cpu и выдаются по 18 MiB/s SSD и 3 MiB/s HDD на ядро. Для HDD применяется коэффициент оверкоммита равный двум (то есть лимит вдвое больше гарантии).

**Проблемы** модели:
* довольно низкое значение IO HDD на cpu в dev сегменте. Такое значение было выбрано по причине небольшого количества HDD в dev сегменте с целью избежать оверквоттинга. Если нужен регулярный быстрый бэкап ВМ рекомендуется использовать SSD.
* гранулярность метрик — 5 секунд, модель использует усреднённое значение за этот интервал. Если для вас важно пиковое потребление, то предложенное значение лимита может оказаться недостаточным.
* часть метрик при старте пода может быть потеряно, т.к. метрики начинают собираться ассинхронно.


Подробно про описание поиска подходящих лимитов для default можно почитать [здесь](https://wiki.yandex-team.ru/users/akorobkov/IO-statistika-po-podam-YP/)

## Как определить размер гарантий/лимитов для ВМ {#check-limits}

Гарантии по IO для ВМ в сегменте dev рекомендуется указывать в зависимости от размера гарантии на CPU для ВМ. Для сегмента default известные конкретные гарантии. Если известно, что ВМ требует больше и есть требуемый объем ресурсов в квоте сервиса, можно выставить бОльшие значения при создании/редактировании.
Лимит рассчитывается автоматически в бэкенде QYP из размера гарантии, указывать его не нужно.

Ниже приведена таблица со схемой расчета, все значения в MB/s:

|     | SSD guarantee | SSD limit | HDD guarantee | HDD limit |
| --- | --- | --- | --- | --- |
| сегмент dev | CPU cores * 18 | max(250, SSD guarantee) | CPU cores * 3 | max(75, HDD guarantee * 2) |
| сегмент default | 30 | max(30, SSD guarantee) | 15 | max(30, HDD guarantee * 2) |

## Как задать гарантии для ВМ {#set-limits-creating}

{% list tabs %}


- UI

  **Через [UI](ui.md#resources)**: в окне редактирования виртуальной машины, в блоке данных `Resources\Disk bandwidth` задать значения для IO HDD/SSD. Затем нажать `Update settings`

  ![](https://jing.yandex-team.ru/files/frolstas/Screenshot%202020-11-17%20at%2015.52.45.png =600x)

  Для выставления значений по стандартной методике расчета нужно нажать `Set default values`

  Если на ноде не хватает IO, то появится ошибка примерно следующего содержания:

  ![](https://jing.yandex-team.ru/files/glebskvortsov/qyp_overcommit.png =300x)

  В таком случае нужно воспользоваться функцией `Backup`

  ![](https://jing.yandex-team.ru/files/glebskvortsov/qyp_backup.png =300x)

  Затем создать новую виртуальную машину из сохраненной резервной копии и одновременно задать параметры IO

  ![](https://jing.yandex-team.ru/files/glebskvortsov/qyp_restore.png =600x)

- CLI

  **Через [CLI](cli.md#create-io-guarantee)**:

  `vmctl update --pod-id <vm> --cluster VLA --io-guarantee-ssd 31457280`.

  Гарантия указывается в байтах или мегабайтах.

- API

  **Через QYP API:**

  Передать в поле `io_guarantees_per_storage` значения гарантий в B/s (байты в секунду) для используемых типов storage (hdd, ssd). Если в ВМ используется только один тип hdd/ssd, передавать нужно только для него.

  <https://a.yandex-team.ru/arc/trunk/arcadia/infra/qyp/proto_lib/vmset.proto?rev=7542606#L106>

  Пример `SSD: 50Mb/s, HDD: 20Mb/s`:

  
  ```json
  JSON
  {
      "io_guarantees_per_storage": {
          "ssd": 52428800, 
          "hdd": 20971520
      }
  }
  
  Protobuf
  io_guarantees_per_storage {
      key: "hdd"
      value: 20971520
  }
  io_guarantees_per_storage {
      key: "ssd"
      value: 52428800
  }
  ```

{% endlist %}

## Выставление гарантий для уже созданных ВМ {#set-limits-vm}

Для ABC-сервисов, на которые уже аккаунтятся QYP-ВМ, в ближайшее время будут заведены тикеты в очереди st/RTCRESOURCES. В тикетах всем ВМ из сервиса подбирается значение io-гарантии, это значение требуется выставить при помощи UI/vmctl.
