# Рецепты по исправлению проблем

## Нехватка ресурсов при создании ВМ {#allocate-no-resources}

В статусе ВМ можно увидеть сообщение вида


```
Could not compute pod allocation: No matching alive node (from 12 in total after filtering) could be allocated for pod.
Number of nodes with unsatisfied constraints: {Cpu: 5, Memory: 6, Disk: 2, Gpu: 11}.
Suggested resources: {Cpu: 8000, Memory: 41845497446, Network: 0, Slot: 1, HddCapacity: 0, SsdCapacity: 328564998144}.
```

Это значит, что YP не удалось найти места для размещения ВМ в рамках выбранной локации и сегмента.

Что делать:
1. Попробовать выбрать другую локацию/другой сегмент.
1. Убедиться, что все ресурсы (количество ядер, размеры памяти, размер диска) заданы верно.
1. Написать в [telegram-rtc-support](https://t.me/joinchat/Be0kOD50fVxMoi_8hPvG6Q).


## Нет доступа по ssh до ВМ {#ssh-issue}

Выполнить последовательно следующие пункты:
1. Проверить, что есть дырки до hostname, порт 22.
1. Проверить статус (`vmctl status`). ВМ должна быть в состоянии RUNNING. Если это не так, выполнить команду запуска (см команду start в разделе Другие команды). После перехода в состояние RUNNING попробовать подключиться еще раз.
1. Проверить ping6 до hostname ВМ. Сразу после запуска нужно немного подождать, прежде чем ВМ начнет отвечать. Проверить ssh после появления пинга.
1. Зайти в ВМ через vnc с доменными логином/паролем (см. раздел [Доступ через vnc](cli.md#vnc)). Если в vnc видно, что ВМ повисла или бесконечно перезагружается, перейти к разделу Проблемы с загрузкой ВМ.
1. Если из ВМ есть доступ до серверов CAuth подробнее, можно посмотреть результат выполнения команды `cauth-info`. Нужные пользователи должны быть в разделах `ssh` или `root`. Пользователи и их ssh-ключи должны появиться в CAuth в течение 5 минут после создания ВМ.
1. Если ничего не помогло, написать в [rtc-support](https://t.me/joinchat/Be0kOD50fVxMoi_8hPvG6Q).

Варианты для срочного получения доступа в ВМ, пока не доехали ключи в CAuth:
1. VNC-консоль.
1. Дать доступ до hostname ВМ через IDM 
   
   {% cut "подробная инструкция" %}
   
   1. Открываем <https://idm.yandex-team.ru/>.
   1. Кликаем на кнопку **Запросить роль**.
   1. Указываем систему **CAuth**.
   1. Указываем префикс источника данных о хостах: `yp`.
   1. Указываем pod-id (имя вашей ВМ).
   1. Выбираем необходимую роль.
   1. После подтверждения роли, ключи доезжают на ВМ за период до 15 мин.
   
   {% endcut %}


### Некорректно указаны источники cauth внутри ВМ {#cauth-issue}

```
$ cat /etc/cauth/cauth.conf 
#CAuth conf generated by sandbox task
sources="yp,cms,idm"
```

Если в файле отсутствует источник `yp`, могут быть проблемы с доступом внутрь ВМ!

Как чинить: поправить файл в файловой системе ВМ. Как зайти на ВМ:
* Через vnc с аккаунтом root (если известен пароль root).
* Попросить зайти пользователя отсюда (указать fqdn своей ВМ) <https://cauth.yandex.net:4443/info/?q=my-shiny-vm.sas.yp-c.yandex.net> с доступом conductor/idm/golem.
* Запросить доступ по ssh до своей ВМ через IDM.


## Проблемы с загрузкой ВМ {#boot-issue}

Описанное ниже применимо к ВМ под управлением Linux-based ОС: ВМ транслирует процесс загрузки в vnc. Если в vnc видно, что ВМ повисла или бесконечно перезагружается, наиболее вероятная причина – побилась файловая система при отключении.

**Причина**: в стандартных поисковых образах ubuntu, собранных до 05.04.19 было отключено журналирование.

**Как починить**: выключить ВМ, зайти в rescue режим через UI или [cli](cli.md#rescue), выполнить [fsck](cli.md#rescue-ex), перезагрузиться.

Проблем с фс при отключении можно избежать, вручную включив журналирование:

1. Зайти в ВМ.
1. Проверить, включено ли журналирование: `sudo debugfs -R features $(realpath $(df --output=source /|sed -e 1d))`. Если журналирование включено, в списке будет `has_journal`.
1. Включить журналирование, выполнив `sudo tune2fs -j $(realpath $(df --output=source /|sed -e 1d))`.

Если проверка не помогла, написать в [rtc-support](https://t.me/joinchat/Be0kOD50fVxMoi_8hPvG6Q)


## Не работает skynet внутри ВМ {#skynet-fb-issue}

Выполнить `ip -6 addr list eth0`. В выводе должно быть три адреса, если это не так, значит проблема с настройкой сети.

**Как починить**:
1. Зайти в ВМ.
1. Для ubuntu >= 16.04: `sudo cloud-init clean` , для остальных: `sudo rm -rf /var/lib/cloud/instances`.
1. Перезагрузить ВМ.



## Не работает сеть в windows ВМ {#windows-network}

1. Выполнить сброс сети.
   
   {% cut "Windows 7" %}
   
   Запустить терминал от администратора и выполнить:
   
   ```
   netsh int ip reset
   netsh int ipv6 reset
   netsh winsock reset
   ```
   
   {% endcut %}

   {% cut "Windows 10" %}
   
   Выполнить сброс через интерфейс, инструкция <https://support.kaspersky.ru/common/windows/12378#block1>
   
   {% endcut %}

1. Перезагрузить ВМ



## ВМ перешла в состояние INVALID при восстановлении из бэкапа {#vm-restore-invalid-status}

ВМ может перейти в INVALID, если невозможно восстановиться из бэкапа. Возможные причины:
* Нехватка места в контейнере, выбран слишком большой образ.
* Нехватка места в контейнере для виртуального диска ВМ.
* Нехватка места на хосте.
* Ошибка скачивания по сети из-за недоступности бэкенда (проблемы сети).
* Образ, из которого нужно восстановить ВМ, больше не существует.

### Как чинить (инструкция для дежурных RTC)

1. Устранить причину.
1. Зайти в /iss_hook_start контейнер ВМ (пример: `ISS-AGENT--my-shiny-vm/my-shuny-vm_qyp_M3zAcEGy3uH/iss_hook_start`).
1. Выполнить `rm /qemu-persistent/last_status`.
1. Выполнить ``` curl -d "" -H "Local-Token: `cat /tmp/vmagent.token`" -g 'http://[::1]:7255/debug?cmd=shutdown' ```
1. Процесс восстановления из бэкапа будет запущен заново.


## Объем диска внутри ВМ не соответствует заданному {#vm-invalid-disk-volume}

Проверить


```
# cloud-init
```

Если команда завершилась с ошибкой, проблема в cloud-init. Именно он увеличивает размер диска до необходимого

**Как чинить:**

В зависимости от содержимого ошибки. Наиболее часто встречается [проблема с jsonpatch](https://github.com/stefankoegl/python-json-patch/issues/56). В этом случае починка будет выглядеть так:


```
$ sudo python3 -m easy_install pip
$ pip3 install --upgrade jsonpatch
$ sudo -i
# рекомендуется также обновить jsonpatch в аккаунте root
$ pip3 install --upgrade jsonpatch
$ cloud-init clean
$ cloud-init init
$ reboot
```

