# User Interface

## Общая информация {#intro}

QYP UI доступен по адресу <https://qyp.yandex-team.ru>

На данной странице представлена помощь по работе с интерфейсом.

## Верхнее меню {#topmenu}

В верхнем меню доступны следующие пункты:
* `Virtual Machines` — переход на страницу со списком виртуальных машин.
* `Backups` — переход на страницу с информацией по резервным копиям ВМ пользователя.
* `Quota` — переход на страницу с информацией по квотам пользователя.

![](https://jing.yandex-team.ru/files/golomolzin/2020-06-04_19-01-29.png =800x)

#### Жучок {#bug-button}

Для того, чтобы сообщить об отмеченных проблемах в сервисе, либо внести предложения по улучшению можно воспользоваться жучком, доступным в шапке UI:

Результатом отправки формы будет созданная задача в очереди <https://st.yandex-team.ru/QEMUKVM>

![](https://jing.yandex-team.ru/files/golomolzin/2020-02-18_12-19-55.png)


## Логин {#login}

QYP доступен только залогиненным пользователям:

При клике на `Login` вы перейдете на страницу паспорта для прохождения процедуры логина.

![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2018-09-18_16-55-29.png =800x)

## Просмотр списка ВМ {#list}

На основном экране UI выводится список виртуальных машин (ВМ), в которых вы были указаны в качестве владельца или имеете к ним доступ.

![](https://jing.yandex-team.ru/files/golomolzin/2020-06-02_11-32-45.png =1000x)

По каждой ВМ выводится краткая информация о ВМ:

![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2018-09-18_00-03-01.png)

* `VM name` — наименование ВМ;
* Маркером `Dev` помечаются ВМ, созданные в сегменте `Development`;
* Маркером `GPU` помечаются ВМ с GPU картами;
* `Location` — локация, в которой создана ВМ;
* `RAM` — аллоцированная под ВМ память;
* `CPU` — аллоцированная под ВМ CPU;
* `Disk` — аллоцированное под ВМ дисковое пространство.


#### Фильтрация записей {#filter}

На странице со списком ВМ доступен функционал фильтрации ВМ: 

![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2019-03-22_17-44-29.png)

Доступна фильтрация по:
* Наименованию ВМ;
* Кластеру;
* Сегменту, в котором создана ВМ.

При помощи переключателя `My/All` имеется возможность отфильтровать виртуальные машины по наличию у вас доступов к ним.


#### Действия со списком ВМ {#actions}

На странице со списком ВМ, при наведении указателя мыши на иконку ![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2018-09-19_13-51-47.png =15x) справа, вам доступны следующие действия:

![](https://jing.yandex-team.ru/files/golomolzin/2020-02-20_14-13-36.png)

* `Start` — старт ВМ (доступность операции зависит от текущего состояния ВМ);
* `Copy` — переход на страницу создания ВМ с копированием конфигурационных параметров текущей ВМ;
* `Poweroff` — выключение ВМ (доступность операции зависит от текущего состояния ВМ);
* `Revert` — откат всех изменений сделанных в виртуальной машине (осуществляется возврат к исходному состоянию образа);
* `Backup` — переход на страницу со списком бэкапов выбранной ВМ с инициацией процедуры создания резервной копии;
* `Deallocate` — деаллокация (удаление) ВМ.

Для того, чтобы создать новую ВМ вам необходимо кликнуть на кнопку **Launch new VM**. После клика откроется страница создания новой ВМ.:
![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2019-03-22_17-52-59.png)


## Создание ВМ {#create}

При создании ВМ задаются базовые настройки гарантий, лимитов, образа, сети и доступов к ВМ:

![](https://jing.yandex-team.ru/files/golomolzin/2020-02-19_20-43-02.png =600x)

### Основные параметры ВМ {#basic-parameters}

В блоке **Basic parameters** вы задаете набор основных параметров вашей ВМ:

![](https://jing.yandex-team.ru/files/golomolzin/2020-02-20_12-51-59.png =600x)

* `VM name` — наименование ВМ. Есть следующие ограничения на формат наименования:
    * длина не более 30 символов
    * можно использовать строчные латинские буквы, цифры и тире (regex `^[a-z0-9\-]+$`)
* `Network Macros` — сетевой макрос из [Racktables](https://racktables.yandex-team.ru/index.php?page=services&tab=projects) для доступа к ВМ по сети.
    * Если у вашего подразделения уже есть свой сетевой макрос, то имеет смысл использовать его – тогда дырки этого макроса будут работать и с вашей ВМ.
    * Если вы не в курсе про сетевые макросы, то рекомендуется отметить чекбокс `Use default macros _SEARCHSAND_`, при этом ваша ВМ будет создана в рамках базового макроса, используемого для разработческих ВМ. Правила для данного макроса можно [посмотреть в puncher](https://puncher.yandex-team.ru/?destination=_SEARCHSAND_&rules=exclude_rejected&values=all&sort=destination) (для просмотра вы должны быть администратором хотя бы одного abc-сервиса).
    * Если вы понимаете, что происходит и какая модель сетевого доступа вам нужна, то можете создать свой сетевой макрос [здесь](https://wiki.yandex-team.ru/NOC/newnetwork/hbf/projectid/project-id-allocation/#opisanieformy), прокрутить нужные дырки и использовать его для ВМ.
* `Autorun` — при включении данной опции (`On`) ВМ автоматически стартует, как только статус ВМ == `Configured` или `Crashed` (статус `Stopped` означает ручную остановку, автозапуска не будет). В этом случае ВМ будет пытаться запуститься, если была аварийно остановлена, например из-за рестарта хоста. По умолчанию опция включена;



### Квота {#quota}

В блоке `Quota` задается набор параметров, связанных с квотой, в рамках которой создается ВМ:

* `Quotas type` — параметр, определяющий за счет какого типа квоты будет создаваться ВМ — доступными вариантами являются использование групповых/сервисных квот (`Group`), либо персональных квот (`Personal`)

![](https://jing.yandex-team.ru/files/golomolzin/2020-02-19_20-45-31.png =600x)

#### Групповые квоты {#group_quotas}

При выборе варианта `Group`, ресурсная квота, в рамках которой осуществляется развертывание ВМ, выдается на ABC-сервис и контролируется YP. В интерфейсе необходимо указать ABC-сервис, на который была выдана квота в YP:
![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2018-09-18_00-46-51.png =600x)

* `ABC Service` — список ABC-сервисов, в которых состоит текущий пользователь

Про то, как запросить квоту в YP можно прочитать в документе ["Заказ квот в YP"](http://wiki.yandex-team.ru/yp/quotas).

#### Персональные квоты {#personal-quotas}

Для сотрудников <https://staff.yandex-team.ru/departments/yandex_main_searchadv/> (точнее для пользователей виртуального сервиса <https://abc.yandex-team.ru/services/qyp_personal/>) доступно использование персональных квот:

![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2019-04-29_13-20-51.png =600x)


{% note warning %}

При недоступности одной из локаций, возможность создания ВМ в персональной квоте будет отключена до восстановления работы локации.

{% endnote %}


![](https://jing.yandex-team.ru/files/dimrul/Screenshot_2019-10-17%20Yandex%20QYP.png)

При этом переключение на персональную квоту будет недоступно, как в примере ниже:

![](https://jing.yandex-team.ru/files/dimrul/Screenshot_2019-10-17%20Yandex%20QYP%281%29.png)


#### Временная квота {#quota-temp}

* `Use temporary account` — если вы хотите протестировать функционал QYP, и вам не хочется связываться с выделением квот на сервис, вы можете выбрать пункт **Use temporary account**.

{% note warning %}

Под временные аккаунты выделяется небольшая часть кластера. Обратите внимание, что в случае его использования, ваша ВМ в любой момент времени может быть удалена!

{% endnote %}

Для разработческих ВМ предназначены сегменты `Development` и `GPU-Development`, для CI/CD - сегмент `Default`. — [подробнее про особенности сегментов](https://wiki.yandex-team.ru/qyp/#4.1.1.1.segmenty); 

* `Segment` — выбор сегмента для размещения виртуальной машины, доступны варианты:
    * `Default`
    * `Development`
    * `GPU Development`
      
      При выборе сегмента `GPU Development` в блоке ресурсов появляются дополнительные поля, позволяющие определить модель и количество GPU карт.
      
      ![](https://jing.yandex-team.ru/files/golomolzin/2020-06-02_11-17-08.png =400x)
      
* `Location` — выбор локации, в которой будет создана ВМ (доступны VLA, SAS, MAN, IVA, MYT);


#### Аллокация хоста целиком {#whole-host}

`Use whole host` — для аллокации хоста целиком под виртуальную машину необходимо  выбрать вариант `enabled`:

![](https://jing.yandex-team.ru/files/golomolzin/2020-02-19_20-57-33.png =400x)

При этом ниже появится элемент `Host Preset`, содержащий список доступных конфигураций в выбранных сегменте (хосты с одинаковыми параметрами сгруппированы в рамках одной конфигурации), локации и с выбранным типом диска (SSD/HDD).

{% note warning %}

При выборе опции все ресурсы хоста, доступные для аллокации через YP, будут вычтены из вашей квоты!

{% endnote %}

* Поле `Preset` может быть использовано для выбора одного из предустановленных наборов ресурсных конфигураций ВМ.


### Ресурсы {#resources}

В блоке `Resources` выводится информация о различных ресурсах создаваемой виртуальной машины:

![](https://jing.yandex-team.ru/files/golomolzin/2020-06-29_15-44-14.png =600x)

* `GPU model` — список моделей GPU карт (выводится **только** в случае выбора сегмента `GPU Development`).
* `Number of GPU cards` — селект, позволяющий задать число GPU карт, пробрасываемых в виртуальную машину (выводится **только** в случае выбора сегмента `GPU Development`).
    
    {% note warning %}

    В сегменте `GPU Development` невозможно создание виртуальных машин без GPU карт!

    {% endnote %}


* `CPU guarantee, cores` — гарантия CPU для ВМ в ядрах (по умолчанию 2 ядра).
* `CPU limit, cores` — лимит CPU для ВМ в ядрах (по умолчанию 32 ядра).
* `RAM, GB` — количество памяти для виртуальной машины (по умолчанию 8G). По факту для ВМ будет выделено на 1GB меньше (1GB используется для нужд инфраструктуры).
* Рядом со строкой ввода параметров ВМ, выводится информация о доступном размере квоты, а также как введенные значения укладываются в нее, данные выводятся в формате `<Уже использованный ресурс>/<Введенное значение>/ <Доступный ресурс>`, справа выводится дополнительный комментарий о количестве доступных для использования ресурсов:
  
  ![](https://jing.yandex-team.ru/files/golomolzin/2020-02-19_21-00-39.png =400x)

* `VM Type` — тип операционной системы вашей ВМ, доступны варианты `Linux`, `Windows`.
* `Internet Access` — выбор настройки доступа ко внешним Интернет-ресурсам:
    * `No Access` — доступ в Интернет из ВМ не нужен.
    * `NAT64` — использование схемы [NAT64](https://wiki.yandex-team.ru/iaas/nat64/) для хождения в IPv4 ресурсы и внешний интернет. Данная опция является предпочтительной, если нужен только доступ до IPv4-only ресурсов (`github.com` и т.д.).
    * `IPv6-IPv4 Tunnel` — аллокация белого IPv4 адреса и автонастройка туннеля.

        {% cut "Дополнительная информация про настройку туннелей" %}

        * информация про маппинг IPv6-IPv4 адресов доезжает в туннелятор через Racktables, накладные расходы составляют до 10 минут);
        * по настройке Интернета в ВМ с Windows см. [Процедура настройки доступа во внешний интернет (IPv4) в Windows](ipv4-windows.md)

        {% endcut %}

* `Disk` — в блоке данных `Disk` конфигурируются параметры диска ВМ - вид стораджа, размер диска, образ, тип диска, гарантии и лимиты на IO:

  ![](https://jing.yandex-team.ru/files/golomolzin/2020-06-29_15-38-30.png =600x)

* `Restore from backup` — при отметке данного чекбокса, вы можете указать ресурс с qdm-бэкапом диска виртуальной машины:
 
  ![](https://jing.yandex-team.ru/files/golomolzin/2020-02-19_21-08-00.png =400x)

* После клика на кнопке `Load disks' meta data` из резервной копии будет подгружена информация о конфигурации дисков виртуальной машины на момент бэкапа.

**Конфигурация дисков**

Диски конфигурируются путем заполнения следующих данных:

* `Type` — место хранения диска ВМ и остальных файлов, выбор из `HDD` и `SSD`;
* `Size, GB` — размер диска в GB. Размер должен быть не меньше, чем размер виртуального диска ВМ + размер образа ВМ + 1GB.

    {% cut "Узнать размер виртуального диска" %}

    Узнать размер виртуального диска можно с помощью утилиты `qemu-img`:

    ```bash
    $ qemu-img info image.qcow2
    image: image.qcow2
    file format: qcow2
    virtual size: 8.0G (8589934592 bytes)
    disk size: 1.7G
    cluster_size: 65536
    Format specific information:
        compat: 0.10
        refcount bits: 16
    % stat -c %s image.qcow2
    1836711936
    ```

    Размер виртуального диска – 8Gb (virtual size в выводе команды), размер образа чуть больше 1.7Gb, следовательно, минимальный размер аллокации равен 10.8Gb.

    {% endcut %}

    Обратите внимание на то, что в квоте под ВМ также должно быть учтено дисковое пространство, расходуемое инфраструктурными компонентами в размере 6Gb.

* `OS Image` (**задается только для системного диска**) — выбор базового образа для вашей ВМ. 
    Доступен набор [предварительно подготовленных образов ubuntu](images-set.md)
    Также вы можете указать свой кастомный образ ВМ, выставив галочку в чекбоксе `Use custom OS Image` и введя значение идентификатора ресурса (http/https/rbtorrent/qdm) в поле ` Custom OS Image`.

    {% note warning %}
    
    Если вы хотите использовать резервную копию (qdm-ресурс) в качестве основы для создаваемой ВМ, используйте для этого опцию **Restore from backup**!

    {% endnote %}

* ` Image Type` — тип диска `raw` (выбрано по умолчанию) или `qcow2`. Рекомендуется использование `raw` 
   
    {% cut "подробнее про типы" %}
   
    * `raw`: в работе вм используется скачанный образ, все изменения пишутся в него
    * `qcow2`: при запуске вм создается новый файл-диск, который содержит изменения относительно базового образа. Не представляет большой пользы в условиях облака, оставлен для обратной совместимости (подробнее про [Redirect-on-Write](http://www.ibm.com/developerworks/tivoli/library/t-snaptsm1/index.html))
   
    {% endcut %}
   
* В блоке `Extra disk` вы можете задать параметры для дополнительного диска
   Добавить еще один диск можно нажав на ссылку `Add disk`. Для дополнительного диска можно задать:
   * `Name` — название диска. Внутри виртуальной машины появится директория с именем `extra_<Name>` (к введнному имени добавится префикс `extra_`).
   * `Type` — тип стораджа.
   * `Size` — размер диска.
   * `Resource URL` — при создании ВМ можно указать ресурс с резервной копией диска.
* В блоке `Disk bandwidth` задаются гарантии и лимиты по IO на чтение:
   Значения для гарантий указываются в Megabytes per second. Если параметры для типа диска не указаны, никакие гарантии/лимиты не применятся для всех томов, использующих этот диск. Лимит будет равен указанной гарантии.

Механика подсчета гарантии для каждого тома: из указанного значения вычитается гарантия для инфраструктурного тома (использует тот же тип диска, что и основной том ВМ), вычисляемая по формуле 

> `min(<размер суммарной гарантии> / 3, 10Mbs)`

полученное значение делится на количество томов с соответствующим типом диска, результат будет указан в качестве гарантии для каждого тома.

{% note alert %}

Функционал по созданию дополнительных дисков **не доступен** для [deprecated версий ОС Linux](https://clubs.at.yandex-team.ru/infra-cloud/709) (precise, trusty). При выборе соответствующей версии ОС, будет выведено соответствующее предупреждение.


Также функционал не доступен для виртуальных машин на базе ОС Windows.

![](https://jing.yandex-team.ru/files/golomolzin/2020-03-11_12-34-33.png =400x)

{% endnote %}

{% note info %}

Если вы занимаете под ВМ хост целиком, вы должны распределить имеющееся дисковое пространство по создаваемым дискам. В случае, если дисковые ресурсы будут недоиспользованы, будет выведено предупреждение.

![](https://jing.yandex-team.ru/files/golomolzin/2020-02-20_12-47-05.png)

{% endnote %}


### Права на ВМ {#permissions}

В блоке `Permissions` вы можете указать список пользователей, являющихся владельцами ВМ:

![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2018-09-18_01-01-46.png =600x)

* `Users` — список логинов пользователей, являющихся владельцами ВМ, перечисленные через запятую. При вводе значения выводится саджест с подходящими вариантами со staff. 
   Владельцы ВМ:
   * имеют право доступа на ВМ;
   * могут получать статусную информацию о ВМ;
   * могут управлять ВМ (рестарт, остановка и т.п.);
   * могут подтверждать доступы к ВМ через [IDM](http://idm.yandex-team.ru/).
* `Groups` — поле для выбора подразделений со staff. Возможен выбор подразделения с использованием саджеста, а также 
   
   {% cut "указание идентификатора" %}
   
   **Как получить group_id для подразделения стаффа**
   Через [staff-api](https://staff-api.yandex-team.ru/v3/). В department.url подставить название подразделения:
   
   ```
   https://staff-api.yandex-team.ru/v3/groups?department.url=yandex_content_geodev_dataprod_data&_one=1&_fields=id
   ```
   
   **Как получить group_id для сервиса ABC**
   Через [staff-api](https://staff-api.yandex-team.ru/v3/). В service.id подставить численный id сервиса ABC:
   
   ```
   https://staff-api.yandex-team.ru/v3/groups?service.id=2900&_one=1&_fields=id
   ```
   
   {% endcut %}
   
   Сотрудники указанных подразделений получат доступ к ВМ в качестве владельцев.

{% note alert %}

Список пользователей, указанный в блоке `Permissions`, также используется при рассылке почтовых уведомлений, призывах в тикеты, относящихся к виртуальной машине. Учтите это при добавлении крупных подразделений!

{% endnote %}



### Процедура создания ВМ {#create-process}

Создание VM инициируется нажатием кнопки **Create**, при клике на кнопку и прохождении валидации введенных параметров, осуществляется переход на страницу с детальной информацией о ВМ с выводом текущего статуса ВМ, который динамически обновляется:

![](https://jing.yandex-team.ru/files/golomolzin/2020-02-20_13-23-06.png =600x)

Процесс создания ВМ состоит из аллокации ресурсов в YP, поднятия контейнера, в котором будет запущена ВМ, скачивания указанного образа ВМ, настройки сети и старта виртуальной машины.

Среднее время создания — 5-10 минут (может быть больше, в зависимости от размера образа ВМ). После старта ВМ статус должен измениться на `Running`.

Статус `Failure` с детализацией `No matching alive node could be allocated for pod` означает, что запрошенные ресурсы не доступны в выбранной локации.


## Детальная информация о ВМ {#view}

При клике на название ВМ в списке осуществляется переход на страницу с детальной информацией о выбранной ВМ:

![](https://jing.yandex-team.ru/files/golomolzin/2020-02-20_13-25-18.png)

На странице доступны следующие действия:
* `Edit` — переход в режим редактирования параметров ВМ.
* `Copy` — переход на страницу создания ВМ с копированием конфигурационных параметров текущей ВМ.
* `Backup` — старт процесса создания резервной копии ВМ.
    
    Перед стартом процесса у вас будет запрошено подтверждение:
 
    ![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2019-03-22_18-30-51.png =400x)

* Перед бэкапом ВМ останавливается автоматически командой `poweroff`. Рекомендуется самостоятельно остановить виртуальную машину посредством команды `shutdown` во избежание повреждения системы
* Перед бэкапом необходимо провести апдейт vmagent, если вы используете старую версию vmagent, вам будет предложено подтвердить его обновление:
   ![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2019-03-22_18-34-54.png)
   Обновить vmagent можно в UI: ![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2019-03-22_18-33-03.png) или [через CLI](cli.md#update-vmagent)

Если вы используете тип диска `qcow2`, то при восстановлении бэкапа вам может не хватить прежних размеров диска (см. [QEMUKVM-345](https://st.yandex-team.ru/QEMUKVM-345)), в качестве workaround предлагаем использовать тип диска `raw`, с которым нет подобных проблем.

* ` Start` — старт ВМ (доступность операции зависит от текущего состояния ВМ).
* ` Poweroff` — выключение ВМ (доступность операции зависит от текущего состояния ВМ).
* ` Revert` — откат всех изменений сделанных в виртуальной машине (осуществляется возврат к исходному состоянию образа).
* ` Deallocate` — деаллокация (удаление) ВМ.

, а также вкладки:

* `VNC` — переход на страницу браузера с VNC клиентом.
* `VM Stats` — переход на страницу с данными мониторингов по выбранной ВМ.
* `Host Stats` — переход на страницу с данными мониторингов по хосту, на котором размещена ВМ.
* `Backup` — данные о бэкапах переехали на вкладку `Backups` [подробнее](#backup).


## Редактирование ВМ {#edit}

Для перехода в режим редактирования ВМ необходимо открыть страницу с детальной информацией и кликнуть на кнопку `Edit`:

![](https://jing.yandex-team.ru/files/golomolzin/2020-02-20_13-38-49.png =1000x)

В режиме редактирования ВМ могут быть изменены следующие параметры:

![](https://jing.yandex-team.ru/files/golomolzin/2020-02-20_13-40-00.png =1000x)

* `Network Macros` — сетевой макрос из [Racktables](https://racktables.yandex-team.ru/index.php?page=services&tab=projects) для доступа к ВМ по сети.
    * Если у вашего подразделения уже есть свой сетевой макрос, то имеет смысл использовать его – тогда дырки этого макроса будут работать и с вашей ВМ.
    * Если вы не в курсе про сетевые макросы, то рекомендуется отметить чекбокс `Use default macros _SEARCHSAND_`, при этом ваша ВМ будет развернута в рамках базового макроса, используемого для разработческих ВМ. Правила для данного макроса можно [посмотреть в puncher](https://puncher.yandex-team.ru/?destination=_SEARCHSAND_&rules=exclude_rejected&values=all&sort=destination) (для просмотра вы должны быть администратором хотя бы одного abc-сервиса).
    * Если вы понимаете, что происходит и какая модель сетевого доступа вам нужна, то можете создать свой сетевой макрос [здесь](https://wiki.yandex-team.ru/NOC/newnetwork/hbf/projectid/project-id-allocation/#opisanieformy), прокрутить нужные дырки и использовать его для ВМ.
* `Autorun` — при включении данной опции (`On`) ВМ автоматически стартует, как только статус ВМ == `Configured` или `Crashed` (статус `Stopped` означает ручную остановку, автозапуска не будет). В этом случае ВМ будет пытаться запуститься, если была аварийно остановлена, например из-за рестарта хоста. По умолчанию опция включена;
* `ABC Service` — ABC-сервис, в рамках квоты которого работает ВМ;
* `CPU, cores` — число виртуальных ядер (тредов), которыми будет оперировать виртуальная машина. По умолчанию `CPU, cores` выставляется равным указанному на этапе создания ВМ значению лимита (`CPU limit, cores`) и не может превышать данное значение.
* `RAM, GB` — количество памяти для виртуальной машины.
* `Use whole host` — для аллокации хоста целиком под виртуальную машину необходимо  выбрать вариант `enabled`: 
   ![](https://jing.yandex-team.ru/files/golomolzin/2020-02-19_20-57-33.png =400x)
   При этом ниже появится элемент `Host Preset`, содержащий список доступных конфигураций в выбранных сегменте (хосты с одинаковыми параметрами сгруппированы в рамках одной конфигурации), локации и с выбранным типом диска (SSD/HDD). 
   **Note:** при выборе опции все ресурсы хоста, доступные для аллокации через YP, будут вычтены из вашей квоты!
* Поле `Preset` может быть использовано для выбора одного из предустановленных наборов ресурсных конфигураций ВМ
* `VM Type` — тип операционной системы вашей ВМ, доступны варианты `Linux`, `Windows`;
* `Конфигурация дисков`:
    * `OS Image` — для системного диска может быть изменен образ. Доступен набор [предварительно подготовленных образов ubuntu](images-set.md):
        * Список предустановленных пакетов: [common_os.sls](https://bb.yandex-team.ru/projects/RTCSALT/repos/saltstack/raw/search_runtime/virtual_image/common_os.sls), [common_os_with_skynet.sls](https://bb.yandex-team.ru/projects/RTCSALT/repos/saltstack/raw/search_runtime/virtual_image/common_os_with_skynet.sls), [common_qemu.sls](https://bb.yandex-team.ru/projects/RTCSALT/repos/saltstack/raw/search_runtime/virtual_image/common_qemu.sls).
        * Список предустановленных пакетов: [common_os.sls](https://bb.yandex-team.ru/projects/RTCSALT/repos/saltstack/raw/search_runtime/virtual_image/common_os.sls), [common_os_with_skynet.sls](https://bb.yandex-team.ru/projects/RTCSALT/repos/saltstack/raw/search_runtime/virtual_image/common_os_with_skynet.sls), [common_qemu.sls](https://bb.yandex-team.ru/projects/RTCSALT/repos/saltstack/raw/search_runtime/virtual_image/common_qemu.sls), [devel_packages.sh](https://a.yandex-team.ru/robots/trunk/genconf/PORTOVM/common/devel_packages.sh).


Также вы можете указать свой кастомный образ ВМ, выставив галочку в чекбоксе `Use custom OS Image` и введя значение идентификатора ресурса (http/https/rbtorrent/qdm) в поле `Custom OS Image`.

Может быть изменен состав дополнительных дисков, для новых дисков можно также указать:

* `Type` — место хранения диска ВМ и остальных файлов, выбор из `HDD` и `SSD`.
* `Size, GB` — размер диска в GB. Размер должен быть не меньше, чем размер виртуального диска ВМ + размер образа ВМ + 1GB.

    {% cut "подробнее" %}

    Узнать размер виртуального диска можно с помощью утилиты `qemu-img`:


    ```
    $ qemu-img info image.qcow2
    image: image.qcow2
    file format: qcow2
    virtual size: 8.0G (8589934592 bytes)
    disk size: 1.7G
    cluster_size: 65536
    Format specific information:
        compat: 0.10
        refcount bits: 16
    % stat -c %s image.qcow2
    1836711936
    ```

    Размер виртуального диска – 8Gb (virtual size в выводе команды), размер образа чуть больше 1.7Gb, следовательно, минимальный размер аллокации равен 10.8G.

    {% endcut %}

    Обратите внимание на то, что в квоте под ВМ также должно быть учтено дисковое пространство, расходуемое инфраструктурными компонентами в размере 6Gb.

    {% note alert %}

    Если вы занимаете под ВМ хост целиком, вы должны распределить имеющееся дисковое пространство по создаваемым дискам. В случае, если дисковые ресурсы будут недоиспользованы, будет выведено предупреждение:

    ![](https://jing.yandex-team.ru/files/golomolzin/2020-02-20_12-47-05.png)

    {% endnote %}


* `Resource URL` — можно указать ресурс с резервной копией диска.

    {% note warning %}

    Если вы указываете образ с системой для дополнительного диска, мы не гарантируем сохранение работоспособности ВМ!

    {% endnote %}
    
* `Internet Access` — выбор настройки доступа ко внешним Интернет-ресурсам:
    * `No Access` — доступ в Интернет из ВМ не нужен;
    * `NAT64` — использование схемы [NAT64](https://wiki.yandex-team.ru/iaas/nat64/) для хождения в IPv4 ресурсы и внешний интернет. Данная опция является предпочтительной, если нужен только доступ до IPv4-only ресурсов (`github.com` и т.д.).
* `Permissions` — в блоке `Permissions` вы можете указать список пользователей, являющихся владельцами ВМ.

* `Users` — список логинов пользователей, являющихся владельцами ВМ, перечисленные через запятую. При вводе значения выводится саджест с подходящими вариантами со staff. Владельцы ВМ:
    * имеют право доступа на ВМ;
    * могут получать статусную информацию о ВМ;
    * могут управлять ВМ (рестарт, остановка и т.п.);
    * могут подтверждать доступы к ВМ через [IDM](http://idm.yandex-team.ru/).
* `Groups` — поле для выбора подразделений со staff. Возможен выбор подразделения с использованием саджеста, а также указание идентификатора:
    * **Как получить group_id для подразделения стаффа**
      
      Через [staff-api](https://staff-api.yandex-team.ru/v3/). В department.url подставить название подразделения:
      
      ```
      https://staff-api.yandex-team.ru/v3/groups?department.url=yandex_content_geodev_dataprod_data&_one=1&_fields=id
      ```
  
    * **Как получить group_id для сервиса ABC**
      Через [staff-api](https://staff-api.yandex-team.ru/v3/). В service.id подставить численный id сервиса ABC:
      
      ```
      https://staff-api.yandex-team.ru/v3/groups?service.id=2900&_one=1&_fields=id
      ```

Сотрудники указанных подразделений получат доступ к ВМ в качестве владельцев.


**Влияние на виртуальную машину**

| **Изменения настройки** | **Применение изменения** |
| --- | --- |
| `ABC Service` | без рестарта ВМ |
| `Permissions` | без рестарта ВМ |
| `Network Macros` | с рестартом ВМ |
| `Autorun` | с рестартом ВМ |
| `Internet Access` (включение/отключение NAT64) | с рестартом ВМ |
| `RAM` | с рестартом ВМ (для версии vmagent < 0.23 будет произведено автоматическое обновление до последней версии агента).  Изменение настройки без пересоздания ВМ возможно только в случае наличия соответствующих ресурсов на ноде (хосте), в противном случае будет выведено   {% cut "сообщение об ошибке от аллокатора:" %}  ![](https://jing.yandex-team.ru/files/golomolzin/2019-09-23_17-25-44.png =300x)  {% endcut %}   |
| `CPU guarantee`, `CPU limit` | с рестартом ВМ (для версии vmagent < 0.23 будет произведено автоматическое обновление до последней версии агента).  Изменение настройки без пересоздания ВМ возможно только в случае наличия соответствующих ресурсов на ноде (хосте), в противном случае будет выведено   {% cut "сообщение об ошибке от аллокатора:" %}  ![](https://jing.yandex-team.ru/files/golomolzin/2019-09-23_17-25-44.png =300x)  {% endcut %}   |
| `VM Type` | будет произведено переразвертывание ВМ, при этом все изменения, сделанные ранее в ВМ, будут утеряны. |
| `Image Type` | будет произведено переразвертывание ВМ, при этом все изменения, сделанные ранее в ВМ, будут утеряны. |
| `OS Image` | будет произведено переразвертывание ВМ, при этом все изменения, сделанные ранее в ВМ, будут утеряны. |



## VNC {#vnc}

На странице доступна возможность использования noVNC клиента для работы с вашей ВМ, для начала работы кликните на кнопке `Connect`:

![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2019-03-22_18-12-29.png =800x)

Далее нажмите любую клавишу и введите свой логин и доменный пароль для логина в ВМ:

![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2019-03-22_18-11-51.png =800x)

![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2019-03-22_18-13-31.png =800x)



## Мониторинг ВМ {#monitoring}

![](https://jing.yandex-team.ru/files/golomolzin/Yandex.QYP_2019-03-22_18-14-21.png =800x)

На странице доступны:
* основные метрики с porto-контейнера по CPU/RAM/Network/Disk Usage, в рамках которого разворачивается ВМ
* набор сигналов с unistat-ручки, характеризующий состояние ВМ:
    * `Configured` — запущен инфраструктурный агент (vmagent), ВМ еще не разворачивалась.
    * `Stopped` — ВМ ранее запускалась, но была остановлена.
    * `Running` — ВМ запущена.
    * `Busy` — осуществляется переход между состояниями.
    * `Preparing` — осуществляется загрузка ресурсов.
    * `Crashed` — невозможна активация инстанса.
    * `Invalid` — применение конфигурации невозможно.
    * `Link Alive` — пингуется IP виртуальной машины.
    * `Net Alive` — можно установить соединение на 22 порту.

Для выбора интересующего временного интервала наведите курсор мыши на "ползунок" сверху - см. [скринкаст](https://jing.yandex-team.ru/files/golomolzin/screencast_2018-09-18_02-16-22.mp4):



## Список резервных копий ВМ {#backup}

На странице выводится информация о резервных копиях виртуальных машин, к которым у пользователя был доступ на момент создания бекапа:

![](https://jing.yandex-team.ru/files/golomolzin/2020-09-02_18-42-26.png =1000x)

* Для каждой резервной копии указывается источник ее возникновения:
    * `USER` — копия создана пользователем.
    * `EVOQ` — копия создана в процессе эвакуации виртуальной машины.
    * `HOT` — копия создана в автоматическом режиме без выключения виртуальной машины.
* Резервные копии удаленных виртуальных машин маркируются лейблом `Removed`:

    ![](https://jing.yandex-team.ru/files/golomolzin/2020-09-02_19-00-51.png =1000x)

* У пользователя есть возможность:
   
    ![](https://jing.yandex-team.ru/files/golomolzin/2020-09-02_18-57-58.png =1000x)
   
    * восстановить ВМ из резервной копии — `Restore`. При попытке восстановления будет запрошено подтвеждение операции поскольку текущие данные диска ВМ будут при этом перезатерты данными диска из резервной копии;
    * использовать копию для создания новой виртуальной машины — `Create VM from Backup`. При создании ВМ на основе резервной копии, из метаданных будет подгружена конфигурация ВМ, сохраненная на момент выполнения бекапа.


## Статистика потребления доступных квот {#profile}

На странице выводится информация о квотах, доступных текущему пользователю:

![](https://jing.yandex-team.ru/files/golomolzin/2020-06-02_13-09-37.png)

**Фильтрация:**

Доступна фильтрация по:
* Сервису (`ABC`)
* Типу ресурса (`Resource`)
* Сегменту (`Segment`)
* ДЦ (`Cluster`)

**Порядок группировки данных:**

Данные группируются в зависимости от выбранного пользователем в блоке `Tree ordering` порядка группировки. Создано несколько пресетов, но у пользователя есть возможность задать необходимый порядок кликнув на checkbox `Pro mode`:

Пример для пресета `ABC/Resource/Segment/Cluster`

![](https://jing.yandex-team.ru/files/golomolzin/2020-06-02_13-17-33.png =1000x)

Пример для пресета `Resource/Cluster/ABC/Segment`

![](https://jing.yandex-team.ru/files/golomolzin/2020-06-02_13-21-35.png =1000x)

* При клике на конечный объект в иерархии выводится детализация по виртуальным машинам:

    ![](https://jing.yandex-team.ru/files/golomolzin/2020-06-02_13-24-56.png =400x)

Доступна фильтрация записей, фильтр позволяет вывести:

* ВМ, созданные текущим пользователем (`My`).
* ВМ, куда пользователь имеет доступ, но не являлся создателем (`Access`).
* полный список ВМ (`All`). По умолчанию выводятся только ВМ, созданные пользователем.

{% note alert  %}

При выводе интегральной статистики по аккаунту `tmp` по сегменту `Default` учтен расход сервисов, но детализация по сервисам **не выводится** (в детализации присутствует только расход по виртуальным машинам)!

{% endnote %}

{% note warning %}

Для того, чтобы просмотреть статистику по квотам другого пользователя необходимо добавить параметр `?login=<login>` в строку запроса.

{% endnote %}

