# Доступы к ВМ

После запуска можно получить доступ к ВМ, используя адрес `<vm_id>.<cluster>.yp-c.yandex.net`.

Для этого должны быть заказаны дырки к сетевому макросу, указанному при аллокации с нужными портами.

## Доступ по ssh {#ssh}

Для [образов из RTC](images-set.md):

Из коробки поддержан sshd демон, который слушает на 22 порту. SSH-ключи автоматически пробрасываются для пользователей, указанных в параметре logins при аллокации ВМ. После аллокации ресурсов доступы доезжают до ВМ в худшем случае за 45мин. Вышеуказанные пользователи становятся также подтверждающим доступы до соответствующей ВМ в IDM.

Для добавления других доступов, необходимо запросить роли в IDM. Пререквизитом для этого является экспорт в IDM информации о ВМ, экспорт производится через сервер CAuth.

{% note warning %}

На текущий момент есть проблемы со скоростью экспорта данных из БД CAuth в БД IDM), время "прорастания" информации может достигать и 24ч (см. тикет <https://st.yandex-team.ru/CAUTH-1314>).

{% endnote %}


Как только данные появились в IDM, остается лишь запросить необходимую роль:

* Открываем <https://idm.yandex-team.ru/>
* Кликаем на кнопку **Запросить роль**.
* Указываем систему **CAuth**.
* Указываем префикс источника данных о хостах: `yp`.
* Указываем pod-id (имя вашей ВМ).
* Выбираем необходимую роль:
   ![](https://jing.yandex-team.ru/files/golomolzin/golomolzin__Roli__IDM_2018-06-26_15-32-24.png)

{% endcut %}

После подтверждения роли, ключи доезжают на ВМ за период до 15 мин.


{% cut "Пример ssh для образа из RTC, логин – root" %}

```
$ ssh root@my-shiny-vm.man.yp-c.yandex.net
Welcome to Ubuntu 16.04 LTS (GNU/Linux 4.4.110-48 x86_64)

 * Documentation:  https://help.ubuntu.com/
Last login: Wed Mar 21 13:56:45 2018 from 2a02:6b8:0:40c:3df8:706e:e757:df3e
root@man2-0892-1:~$ 
```

{% endcut %}


## Доступ через vnc {#vnc}

Осуществляется через сервис noVNC, который обеспечивает аутентифицированный и авторизованный доступ к VNC-консоли виртуальных машин из браузера (через Websockets).
Пользователь аутентифицируется по cookie Session_id (появляется в браузере после логина в *.yandex-team.ru)
Получить доступ могут только пользователи, указанные в `logins` и `groups` при аллокации.

При вызове команды `vmctl vnc` будет осуществлен запрос статуса ВМ по с указанными идентификационными параметрами и oauth-токеном.
Если ВМ запущена (находится в RUNNING), будет сгенерирована ссылка для открытия в браузере. Также, утилита попытается открыть новую вкладку в браузере с этой ссылкой.

Пароль для VNC автоматически генерируется при конфигурировании ВМ в инстансе, значение доступно через `vmctl status`.


```
$ vmctl vnc --cluster MAN --pod-id my-shiny-vm
VNC url: https://rtc-kvm-novnc.yandex-team.ru/vnc.html?path=?cluster%3DMAN%26pod_id%3Dmy-shiny-vm&password=auto_generated_password
VNC password: auto_generated_password
```

Также в посмотреть в vnc можно из QYP UI:
1. <https://qyp.yandex-team.ru/>
1. Перейти на страницу интересующей ВМ.
1. Открыть вкладку VNC.


{% note warning %}

В VNC можно зайти с доменным аккаунтом и паролем только если в образе установлен CAuth (есть в стандартных образах). Если его нет, получить доступ к виртуальной машине можно, зная зашитые в образ логины и пароли. Если эти данные неизвестны, можно выставить пароль для root через rescue shell ([как попасть в rescue](cli.md#rescue), [примеры команд в rescue](cli.md#rescue-ex)) и после перезагрузки зайти с новым паролем.

{% endnote %}
