#!/usr/bin/env python2.7

from infra.qyp.novnc_server.src import application

try:
    import argparse
    from infra.swatlib import cmdutil
except KeyboardInterrupt:
    # don't bother user with python stack trace
    # if interrupted (by Ctrl+C) during imports
    raise SystemExit(1)


def init_arg_parser():
    parser = argparse.ArgumentParser(prog=application.Application.name)
    parser.add_argument('-c', '--cfg',
                        default=None,
                        action='store', help='path to service cfg file')
    parser.add_argument('--console',
                        default=False,
                        action='store_true',
                        help='redirect log to stdout (overrides config)')
    return parser


def main():
    arg_parser = init_arg_parser()
    cmdutil.main(arg_parser, application.Application, env_prefix='VMPROXY')


if __name__ == '__main__':
    main()
