import argparse

from infra.qyp.novnc_server import application
from infra.swatlib import cmdutil


def init_arg_parser():
    parser = argparse.ArgumentParser(prog=application.Application.name)
    parser.add_argument('-c', '--cfg',
                        default=None,
                        action='store', help='path to service cfg file')
    parser.add_argument('--console',
                        default=False,
                        action='store_true',
                        help='redirect log to stdout (overrides config)')
    return parser


def main():
    cmdutil.main(init_arg_parser(), application.Application, env_prefix='VMPROXY')


if __name__ == '__main__':
    main()
