from Cookie import SimpleCookie

import inject
from infra.qyp.novnc_server.contrib.websockify import auth_plugins as auth

from infra.swatlib.auth.passport import IPassportClient
from infra.qyp.vmproxy.src import vm_instance


class VMAgentAuth(object):
    passport = inject.attr(IPassportClient)

    def __init__(self, ctx):
        """
        :type ctx: vmproxy.web.app.Ctx
        """
        self.ctx = ctx

    def authenticate(self, headers, userip, **kwargs):
        cookie_hdr = headers.getheader('cookie', None)
        cookies = {key: morsel.value for key, morsel in SimpleCookie(cookie_hdr).iteritems()}
        try:
            result = self.passport.check_passport_cookie(
                cookies=cookies,
                host=headers.getheader('host'),
                user_ip=userip,
                request_url=None
            )
        except Exception as e:
            raise auth.AuthenticationError(response_code=400, response_msg=e)

        login = result.login
        if not login:
            raise auth.AuthenticationError(response_code=400, response_msg='Cannot authenticate user')

        try:
            cluster = kwargs.get('cluster')
            if cluster:
                pod_ctl = self.ctx.pod_ctl_factory.get_object(cluster)
                ctx = self.ctx.make_request_context(pod_ctl)
            else:
                ctx = self.ctx
            instance = vm_instance.get_instance(args=kwargs, ctx=ctx)
        except Exception as e:
            raise auth.AuthenticationError(response_msg=e)

        try:
            instance.check_access(login, ctx)
        except Exception as e:
            raise auth.AuthenticationError(response_msg=e)

        return instance
