import sys
import urlparse

from infra.qyp.novnc_server.contrib.websockify import websocketproxy, auth_plugins as auth


class CustomRequestHandler(websocketproxy.ProxyRequestHandler):
    def validate_connection(self):
        try:
            # get client certificate data
            client_cert_data = self.request.getpeercert()
            # extract subject information
            client_cert_subject = client_cert_data['subject']
            # flatten data structure
            client_cert_subject = dict([x[0] for x in client_cert_subject])
            # add common name to headers (apache +StdEnvVars style)
            self.headers['SSL_CLIENT_S_DN_CN'] = client_cert_subject['commonName']
        except (TypeError, AttributeError, KeyError):
            # not a SSL connection or client presented no certificate with valid data
            pass

        parsed = urlparse.urlparse(self.path)
        params = dict(urlparse.parse_qsl(parsed.query))
        # For backward compatibility
        if 'token' in params:
            service, host, port = self.get_target(self.server.token_plugin, self.path)
            params = {
                'service': service,
                'host': host,
                'port': str(int(port) - 3)
            }
        try:
            instance = self.server.auth_plugin.authenticate(
                headers=self.headers,
                userip=self.client_address[0],
                **params
            )
        except auth.AuthenticationError:
            ex = sys.exc_info()[1]
            self.send_auth_error(ex)
            raise
        else:
            host_, port_ = instance.get_vnc_host_port()
            self.server.target_host = host_
            self.server.target_port = port_
