import logging

import requests
from requests.adapters import HTTPAdapter
from requests.packages.urllib3.util.retry import Retry

import ticket_parser2.api.v1 as tp2


QDM_TVM_CLIENT_ID = 2014800
MDS_TESTING_CLIENT_ID = 2000468
MDS_CLIENT_ID = 2000273


class MdsClient(object):
    def __init__(self, tvm_secret):
        retry_strategy = Retry(
            total=3,
            status_forcelist=[429, 500, 502, 503, 504],
            method_whitelist=["HEAD", "GET", "OPTIONS", "POST"],
            backoff_factor=2
        )
        adapter = HTTPAdapter(max_retries=retry_strategy)
        self.http = requests.Session()
        self.http.mount("https://", adapter)
        self.http.mount("http://", adapter)

        self.tvm_client = tp2.TvmClient(tp2.TvmApiClientSettings(
            self_client_id=QDM_TVM_CLIENT_ID,
            self_secret=tvm_secret,
            dsts={"mds": MDS_CLIENT_ID},
        ))
        self.log = logging.getLogger('mds_client')

    def get_tvm_ticket(self):
        return self.tvm_client.get_service_ticket_for('mds')

    def drop_block_mds(self, key):
        """
        :type key: str
        :rtype: bool
        """
        try:
            tvm_ticket = self.get_tvm_ticket()
            url = 'http://storage-int.mds.yandex.net:1111/delete-qdm/{}'.format(key)
            rsp = self.http.post(url, headers={'X-Ya-Service-Ticket': tvm_ticket})
            rsp.raise_for_status()
        except Exception as e:
            self.log.error(e)
            return False
        else:
            return True
