import json

import requests


class VmproxyClient(object):
    DEFAULT_TIMEOUT = 60

    def __init__(self, oauth_token, timeout=None):
        self.oauth_token = oauth_token
        self.timeout = timeout or self.DEFAULT_TIMEOUT
        self.headers = {
            'Content-Type': 'application/json',
            'Authorization': 'OAuth %s' % (self.oauth_token,)
        }

    def api_call(self, url, data):
        response = requests.post(url, data=json.dumps(data), headers=self.headers, timeout=self.timeout)
        return response
