import time

import gevent

from . import db


LOCKS = {
    'data_cleaner': 2137285846758508504,
    'job_mngr': 1086568398063200187,
}


class AdvisoryLock(object):
    def __init__(self, db, key):
        self.db = db
        self.key = LOCKS[key]
        self._locked = False

    def __enter__(self):
        self.db._ex_lock.acquire()

        deadline = time.time() + 600

        while time.time() < deadline:
            if not self.db.connected():
                try:
                    self.db.reconnect()
                except:
                    gevent.sleep(10)
                else:
                    break
            else:
                break

        self.db.__enter__()

        try:
            self.db.query('SELECT pg_advisory_lock(%s)', (self.key, ))
        except db.errors.LockNotAvailable:
            return False
        else:
            self._locked = True
            return True

    def __exit__(self, type, value, traceback):
        try:
            try:
                self.db.__exit__(type, value, traceback)
            finally:
                self.db._ex_lock.release()
        except:
            pass
        else:
            # Unlocking will only be tried if db.__exit__ does not spawn exception
            if self._locked:
                self.db.query('SELECT pg_advisory_unlock(%s)', (self.key, ))
