import requests
import time

import ticket_parser2 as tp2
import ticket_parser2.low_level as tp2api


QDM_TVM_CLIENT_ID = 2014800
MDS_TESTING_CLIENT_ID = 2000468
MDS_CLIENT_ID = 2000273

TVM_KEYS = None
TVM_KEYS_TS = 0
TVM_KEYS_LIFE = 3600  # update keys every hour


def generate_mds_ticket(secret):
    global TVM_KEYS, TVM_KEYS_TS

    src = QDM_TVM_CLIENT_ID
    dst = MDS_CLIENT_ID

    ts = int(time.time())

    if time.time() - TVM_KEYS_TS > TVM_KEYS_LIFE:
        tvm_keys = requests.get(
            'https://tvm-api.yandex.net/2/keys?lib_version=%s' % (tp2.__version__, )
        ).content.decode('utf-8')
        TVM_KEYS = TVM_KEYS
        TVM_KEYS_TS = int(time.time())
    else:
        tvm_keys = TVM_KEYS

    svc_ctx = tp2api.ServiceContext(src, secret, tvm_keys)

    ticket_response = requests.post(
        'https://tvm-api.yandex.net/2/ticket/',
        data={
            'grant_type': 'client_credentials',
            'src': src,
            'dst': dst,
            'ts': ts,
            'sign': svc_ctx.sign(ts, dst)
        }
    ).json()

    ticket = ticket_response[str(dst)]['ticket']

    return ticket
