from __future__ import unicode_literals

import sys
import logging
from logging import handlers

import os

from sepelib.util.log import setup_logging_to_file

LOG_MAX_BYTES = 10 ** 7
LOG_BACKUP_COUNT = 10


def _create_log_handler(log_path):
    return handlers.RotatingFileHandler(log_path, maxBytes=LOG_MAX_BYTES, backupCount=LOG_BACKUP_COUNT)


def setup_logging(vmagent_context):
    """

    :type vmagent_context: infra.qyp.vmagent.src.config.VmagentContext
    :return:
    """
    # disable requests module logging
    logging.getLogger('requests').setLevel(logging.WARNING)
    logging.getLogger('requests.packages.urllib3.connectionpool').setLevel(logging.ERROR)

    # Common logger
    if not os.path.exists(vmagent_context.LOGS_FOLDER_PATH):
        os.mkdir(vmagent_context.LOGS_FOLDER_PATH)
    handler = _create_log_handler(vmagent_context.VMAGENT_LOG_FILE_PATH)
    logger = setup_logging_to_file(handler, redirect_stderr=False)

    # Output CRITICAL to stderr
    stderr_handler = logging.StreamHandler(sys.stderr)
    stderr_handler.setLevel(logging.ERROR)
    logger.addHandler(stderr_handler)
