# qemu_network.sh

if [ "$SANDBOX_INSTALL_MODE" ]; then
    cp $0 /usr/sbin/qemu_network.sh
	exit 0
fi

mac2ll(){
    local MACSTR="$1"

    IFS=":" read -a MAC <<< "$MACSTR"

    local OCTET0=$((0x${MAC[0]} ^ 0x2 ))

    echo "fe80::""`printf %02x $OCTET0`""${MAC[1]}:${MAC[2]}ff:fe${MAC[3]}:${MAC[4]}${MAC[5]}"
}

if [ "$1" ]; then
    PORT="$1"
fi

: ${PORT:=7255}
: ${TAP_MTU:=1400}
: ${USE_NAT64:=""}

PORTHI=$((PORT >> 8))
PORTLO=$((PORT & 0xff))

LLADDR="52:54:00:00:`printf %02x $PORTHI`:`printf %02x $PORTLO`"
VMLLADDR="52:54:00:00:12:34:56"

while [ -z "$YP_RESP" ]; do
    YP_RESP=$(curl -fs --unix-socket /var/run/iss/pod.socket http://localhost/pod_spec)
    sleep 5
done
ADDRS=$(jq -n "$YP_RESP" | jq '[.ip6AddressAllocations[] | select(.labels.attributes[].value == "AQR2bQ==")]')
export VM_IP=$(jq -n "$ADDRS" | jq -r '.[] | select(.vlanId == "backbone") | .address')
export VM_AUX_IP=$(jq -n "$ADDRS" | jq -r '.[] | select(.vlanId == "fastbone") | .address')

DEV="veth"

export TAP_LL=`mac2ll $LLADDR`
export TAP_DEV="tap$PORT"
export HOSTNAME=`hostname`
export HOST=`hostname`

sudo ip -6 addr del dev $DEV $VM_IP || true
sudo ip -6 addr del dev $DEV $VM_AUX_IP || true

sudo ip -6 link del dev $TAP_DEV || true
sudo ip -6 tuntap add dev $TAP_DEV mode tap user loadbase group loadbase

sudo ip -6 link set dev $TAP_DEV address $LLADDR
sudo ip addr replace 192.168.1.1/24 dev $TAP_DEV
sudo ip -6 addr replace fe80::1/64 dev $TAP_DEV

sudo ip -6 link set dev $TAP_DEV up

# Impose no limits on link container<->VM
sudo ip link set dev $TAP_DEV mtu 9000

sudo ip -6 route add $VM_IP/128 dev $TAP_DEV
sudo ip -6 route add $VM_AUX_IP/128 dev $TAP_DEV

sudo ip -6 nei add proxy $VM_IP dev $DEV
sudo ip -6 nei add proxy $VM_AUX_IP dev $DEV

# NAT v4 traffic - NAT local v4 traffic from VM to ipip6 tunnel
# required for v4 internet access
if ! sudo iptables -t nat -C POSTROUTING -j MASQUERADE -o ip_ext_tun0 ; then
    sudo iptables -t nat -A POSTROUTING -j MASQUERADE -o ip_ext_tun0
fi

if [ -z $USE_NAT64 ]; then
    NAMESERVERS="2a02:6b8::1:1 2a02:6b8:0:3400::1"
else
    NAMESERVERS="2a02:6b8:0:3400::5005 2a02:6b8::1:1 2a02:6b8:0:3400::1"
fi

# Dhcpv6 utils config below (Windows and foreign Linux)
# RA - instruct to poke DHCPv6
sudo tee /etc/radvd.conf <<EOF
interface $TAP_DEV {
    AdvSendAdvert on;
    AdvManagedFlag on;
    AdvOtherConfigFlag on;
    MaxRtrAdvInterval 20;
    AdvDefaultLifetime 1800;
    RDNSS $NAMESERVERS {
        AdvRDNSSLifetime infinity;
    };
    AdvLinkMTU 1400;
};
EOF

# Provide valid allocated IP for VM
sudo tee /etc/wide-dhcpv6/dhcp6s.conf <<EOF
option domain-name "yp-c.yandex.net";
option domain-name-servers $NAMESERVERS;
interface $TAP_DEV {
    address-pool pool1 360;
};
pool pool1 {
    range $VM_IP to $VM_IP;
};
EOF

# We need TAP_MTU to route v4 internet traffic
sudo tee /etc/udhcpd.conf <<EOF
start 192.168.1.3
end 192.168.1.255
interface $TAP_DEV
static_lease 52:54:00:12:34:56 192.168.1.2
option router 192.168.1.1
option subnet 255.255.255.0
option mtu $TAP_MTU
EOF