# qemu_rescue.sh

export DEBIAN_FRONTEND="noninteractive"

apt-get update -y

# ignore update-grub abscene
apt-get install -y --no-install-recommends --allow-unauthenticated linux-image-$RESCUE_KERNEL_VERSION linux-firmware udev initramfs-tools ntfs-3g || true

ln -s /boot/vmlinuz-$RESCUE_KERNEL_VERSION /boot/vmlinuz
ln -s /boot/initrd.img-$RESCUE_KERNEL_VERSION /boot/initrd

# Script from Xenial

tee /usr/share/initramfs-tools/hooks/fsck << FSCK_EOF
#!/bin/sh

PREREQ=""

prereqs()
{
	echo "\$PREREQ"
}

case \$1 in
prereqs)
	prereqs
	exit 0
	;;
esac

if [ ! -x /sbin/fsck ]; then
	exit 0
fi

. /usr/share/initramfs-tools/scripts/functions
. /usr/share/initramfs-tools/hook-functions

fsck_types="ext2 ext3 ext4 ext4dev"

if [ -z "\$fsck_types" ]; then
	exit 0
fi

copy_exec /sbin/fsck
copy_exec /sbin/logsave

# e2fsck may fail or warn if the system time is not yet correct, which
# will happen if the RTC driver is modular or the RTC is set to local
# time.  Disable this behaviour.  (No other fsck does this, apparently.)
mkdir -p "\${DESTDIR}/etc"
cat >"\${DESTDIR}/etc/e2fsck.conf" <<EOF
[options]
broken_system_clock=1
EOF

for type in \$fsck_types; do
	if [ "\$type" = 'auto' ] ; then
		echo "Warning: couldn't identify filesystem type for fsck hook, ignoring."
		continue
	fi

	if prog="\$(command -v fsck.\${type})"; then
		copy_exec "\$prog"
	else
		echo "Warning: /sbin/fsck.\${type} doesn't exist, can't install to initramfs, ignoring."
	fi
done

FSCK_EOF

chmod +x /usr/share/initramfs-tools/hooks/fsck

tee /usr/share/initramfs-tools/hooks/vim << VIM_EOF
#!/bin/sh

PREREQ=""

prereqs()
{
        echo "\$PREREQ"
}

case \$1 in
prereqs)
        prereqs
        exit 0
        ;;
esac

if [ ! -x /usr/bin/vim.tiny ]; then
        exit 0
fi

. /usr/share/initramfs-tools/scripts/functions
. /usr/share/initramfs-tools/hook-functions

copy_exec /usr/bin/vim.tiny /sbin/vim

VIM_EOF

chmod +x /usr/share/initramfs-tools/hooks/vim


update-initramfs -u -k all -v